"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const get_1 = __importDefault(require("lodash/get"));
const set_1 = __importDefault(require("lodash/set"));
const cloneDeep_1 = __importDefault(require("lodash/cloneDeep"));
const errors_1 = require("@feathersjs/errors");
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@feathersjs/authentication-local/hooks/hash-password');
function hashPassword(field, options = {}) {
    if (!field) {
        throw new Error('The hashPassword hook requires a field name option');
    }
    return (context) => __awaiter(this, void 0, void 0, function* () {
        if (context.type !== 'before') {
            throw new Error(`The 'hashPassword' hook should only be used as a 'before' hook`);
        }
        const { app, data, params } = context;
        if (data === undefined) {
            debug(`hook.data is undefined. Skipping hashPassword hook.`);
            return context;
        }
        const authService = app.defaultAuthentication(options.authentication);
        const { strategy = 'local' } = options;
        if (!authService || typeof authService.getStrategies !== 'function') {
            throw new errors_1.BadRequest(`Could not find an authentication service to hash password`);
        }
        const [localStrategy] = authService.getStrategies(strategy);
        if (!localStrategy || typeof localStrategy.hashPassword !== 'function') {
            throw new errors_1.BadRequest(`Could not find '${strategy}' strategy to hash password`);
        }
        const addHashedPassword = (data) => __awaiter(this, void 0, void 0, function* () {
            const password = (0, get_1.default)(data, field);
            if (password === undefined) {
                debug(`hook.data.${field} is undefined, not hashing password`);
                return data;
            }
            const hashedPassword = yield localStrategy.hashPassword(password, params);
            return (0, set_1.default)((0, cloneDeep_1.default)(data), field, hashedPassword);
        });
        context.data = Array.isArray(data) ? yield Promise.all(data.map(addHashedPassword)) :
            yield addHashedPassword(data);
        return context;
    });
}
exports.default = hashPassword;
//# sourceMappingURL=hash-password.js.map