# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## [4.5.18](https://github.com/feathersjs/feathers/compare/v4.5.17...v4.5.18) (2023-07-19)

**Note:** Version bump only for package @feathersjs/authentication





## [4.5.17](https://github.com/feathersjs/feathers/compare/v4.5.16...v4.5.17) (2023-07-17)

**Note:** Version bump only for package @feathersjs/authentication





## [4.5.16](https://github.com/feathersjs/feathers/compare/v4.5.15...v4.5.16) (2023-02-24)


### Bug Fixes

* **dependencies:** Update dependencies ([70335c4](https://github.com/feathersjs/feathers/commit/70335c4c7c0fd15ab6d1c2a617eb17fcf864fadf))





## [4.5.15](https://github.com/feathersjs/feathers/compare/v4.5.14...v4.5.15) (2022-05-17)

**Note:** Version bump only for package @feathersjs/authentication





## [4.5.14](https://github.com/feathersjs/feathers/compare/v4.5.13...v4.5.14) (2022-04-13)

**Note:** Version bump only for package @feathersjs/authentication





## [4.5.12](https://github.com/feathersjs/feathers/compare/v4.5.11...v4.5.12) (2022-01-06)


### Bug Fixes

* Update all dependencies for crow release ([#2520](https://github.com/feathersjs/feathers/issues/2520)) ([1c63e6b](https://github.com/feathersjs/feathers/commit/1c63e6be37ff85edbe8dd318415ca6919864c033))





## [4.5.11](https://github.com/feathersjs/feathers/compare/v4.5.10...v4.5.11) (2020-12-05)

**Note:** Version bump only for package @feathersjs/authentication





## [4.5.10](https://github.com/feathersjs/feathers/compare/v4.5.9...v4.5.10) (2020-11-08)


### Bug Fixes

* **authentication:** consistent response return between local and jwt strategy ([#2042](https://github.com/feathersjs/feathers/issues/2042)) ([8d25be1](https://github.com/feathersjs/feathers/commit/8d25be101a2593a9e789375c928a07780b9e28cf))





## [4.5.9](https://github.com/feathersjs/feathers/compare/v4.5.8...v4.5.9) (2020-10-09)

**Note:** Version bump only for package @feathersjs/authentication





## [4.5.8](https://github.com/feathersjs/feathers/compare/v4.5.7...v4.5.8) (2020-08-12)

**Note:** Version bump only for package @feathersjs/authentication





## [4.5.7](https://github.com/feathersjs/feathers/compare/v4.5.6...v4.5.7) (2020-07-24)


### Bug Fixes

* **authentication:** Add JWT getEntityQuery ([#2013](https://github.com/feathersjs/feathers/issues/2013)) ([e0e7fb5](https://github.com/feathersjs/feathers/commit/e0e7fb5162940fe776731283b40026c61d9c8a33))





## [4.5.6](https://github.com/feathersjs/feathers/compare/v4.5.5...v4.5.6) (2020-07-12)


### Bug Fixes

* **authentication:** Omit query in JWT strategy ([#2011](https://github.com/feathersjs/feathers/issues/2011)) ([04ce7e9](https://github.com/feathersjs/feathers/commit/04ce7e98515fe9d495cd0e83e0da097e9bcd7382))





## [4.5.5](https://github.com/feathersjs/feathers/compare/v4.5.4...v4.5.5) (2020-07-11)


### Bug Fixes

* **authentication:** Include query params when authenticating via authenticate hook [#2009](https://github.com/feathersjs/feathers/issues/2009) ([4cdb7bf](https://github.com/feathersjs/feathers/commit/4cdb7bf2898385ddac7a1692bc9ac2f6cf5ad446))





## [4.5.3](https://github.com/feathersjs/feathers/compare/v4.5.2...v4.5.3) (2020-04-17)


### Bug Fixes

* **authentication:** Remove entity from connection information on logout ([#1889](https://github.com/feathersjs/feathers/issues/1889)) ([b062753](https://github.com/feathersjs/feathers/commit/b0627530d61babe15dd84369d3093ccae4b780ca))





## [4.5.2](https://github.com/feathersjs/feathers/compare/v4.5.1...v4.5.2) (2020-03-04)


### Bug Fixes

* **authentication:** Improve JWT strategy configuration error message ([#1844](https://github.com/feathersjs/feathers/issues/1844)) ([2c771db](https://github.com/feathersjs/feathers/commit/2c771dbb22d53d4f7de3c3f514e57afa1a186322))





## [4.5.1](https://github.com/feathersjs/feathers/compare/v4.5.0...v4.5.1) (2020-01-24)

**Note:** Version bump only for package @feathersjs/authentication





# [4.5.0](https://github.com/feathersjs/feathers/compare/v4.4.3...v4.5.0) (2020-01-18)


### Bug Fixes

* Add `params.authentication` type, remove `hook.connection` type ([#1732](https://github.com/feathersjs/feathers/issues/1732)) ([d46b7b2](https://github.com/feathersjs/feathers/commit/d46b7b2abac8862c0e4dbfce20d71b8b8a96692f))





## [4.4.3](https://github.com/feathersjs/feathers/compare/v4.4.1...v4.4.3) (2019-12-06)

**Note:** Version bump only for package @feathersjs/authentication





## [4.4.1](https://github.com/feathersjs/feathers/compare/v4.4.0...v4.4.1) (2019-11-27)

**Note:** Version bump only for package @feathersjs/authentication





# [4.4.0](https://github.com/feathersjs/feathers/compare/v4.3.11...v4.4.0) (2019-11-27)

**Note:** Version bump only for package @feathersjs/authentication





## [4.3.11](https://github.com/feathersjs/feathers/compare/v4.3.10...v4.3.11) (2019-11-11)


### Bug Fixes

* **authentication:** Retain object references in authenticate hook ([#1675](https://github.com/feathersjs/feathers/issues/1675)) ([e1939be](https://github.com/feathersjs/feathers/commit/e1939be19d4e79d3f5e2fe69ba894a11c627ae99))





## [4.3.10](https://github.com/feathersjs/feathers/compare/v4.3.9...v4.3.10) (2019-10-26)

**Note:** Version bump only for package @feathersjs/authentication





## [4.3.9](https://github.com/feathersjs/feathers/compare/v4.3.8...v4.3.9) (2019-10-26)


### Bug Fixes

* Add jsonwebtoken TypeScript type dependency ([317c80a](https://github.com/feathersjs/feathers/commit/317c80a9205e8853bb830a12c3aa1a19e95f9abc))
* Small type improvements ([#1624](https://github.com/feathersjs/feathers/issues/1624)) ([50162c6](https://github.com/feathersjs/feathers/commit/50162c6e562f0a47c6a280c4f01fff7c3afee293))





## [4.3.7](https://github.com/feathersjs/feathers/compare/v4.3.6...v4.3.7) (2019-10-14)

**Note:** Version bump only for package @feathersjs/authentication





## [4.3.5](https://github.com/feathersjs/feathers/compare/v4.3.4...v4.3.5) (2019-10-07)


### Bug Fixes

* Authentication type improvements and timeout fix ([#1605](https://github.com/feathersjs/feathers/issues/1605)) ([19854d3](https://github.com/feathersjs/feathers/commit/19854d3))
* Improve error message when authentication strategy is not allowed ([#1600](https://github.com/feathersjs/feathers/issues/1600)) ([317a312](https://github.com/feathersjs/feathers/commit/317a312))





## [4.3.4](https://github.com/feathersjs/feathers/compare/v4.3.3...v4.3.4) (2019-10-03)

**Note:** Version bump only for package @feathersjs/authentication





## [4.3.3](https://github.com/feathersjs/feathers/compare/v4.3.2...v4.3.3) (2019-09-21)


### Bug Fixes

* check for undefined access token ([#1571](https://github.com/feathersjs/feathers/issues/1571)) ([976369d](https://github.com/feathersjs/feathers/commit/976369d))
* Small improvements in dependencies and code sturcture ([#1562](https://github.com/feathersjs/feathers/issues/1562)) ([42c13e2](https://github.com/feathersjs/feathers/commit/42c13e2))





## [4.3.2](https://github.com/feathersjs/feathers/compare/v4.3.1...v4.3.2) (2019-09-16)

**Note:** Version bump only for package @feathersjs/authentication





## [4.3.1](https://github.com/feathersjs/feathers/compare/v4.3.0...v4.3.1) (2019-09-09)


### Bug Fixes

* Use long-timeout for JWT expiration timers ([#1552](https://github.com/feathersjs/feathers/issues/1552)) ([65637ec](https://github.com/feathersjs/feathers/commit/65637ec))





# [4.3.0](https://github.com/feathersjs/feathers/compare/v4.3.0-pre.4...v4.3.0) (2019-08-27)

**Note:** Version bump only for package @feathersjs/authentication





# [4.3.0-pre.4](https://github.com/feathersjs/feathers/compare/v4.3.0-pre.3...v4.3.0-pre.4) (2019-08-22)


### Bug Fixes

* Fix auth publisher mistake ([08bad61](https://github.com/feathersjs/feathers/commit/08bad61))





# [4.3.0-pre.3](https://github.com/feathersjs/feathers/compare/v4.3.0-pre.2...v4.3.0-pre.3) (2019-08-19)


### Bug Fixes

* Expire and remove authenticated real-time connections ([#1512](https://github.com/feathersjs/feathers/issues/1512)) ([2707c33](https://github.com/feathersjs/feathers/commit/2707c33))
* Update all dependencies ([7d53a00](https://github.com/feathersjs/feathers/commit/7d53a00))


### Features

* Let strategies handle the connection ([#1510](https://github.com/feathersjs/feathers/issues/1510)) ([4329feb](https://github.com/feathersjs/feathers/commit/4329feb))





# [4.3.0-pre.2](https://github.com/feathersjs/feathers/compare/v4.3.0-pre.1...v4.3.0-pre.2) (2019-08-02)


### Bug Fixes

* Add getEntityId to JWT strategy and fix legacy Socket authentication ([#1488](https://github.com/feathersjs/feathers/issues/1488)) ([9a3b324](https://github.com/feathersjs/feathers/commit/9a3b324))
* Add method to reliably get default authentication service ([#1470](https://github.com/feathersjs/feathers/issues/1470)) ([e542cb3](https://github.com/feathersjs/feathers/commit/e542cb3))





# [4.3.0-pre.1](https://github.com/feathersjs/feathers/compare/v4.0.0-pre.5...v4.3.0-pre.1) (2019-07-11)

**Note:** Version bump only for package @feathersjs/authentication





# [4.0.0-pre.5](https://github.com/feathersjs/feathers/compare/v4.0.0-pre.4...v4.0.0-pre.5) (2019-07-10)

**Note:** Version bump only for package @feathersjs/authentication





# [4.0.0-pre.4](https://github.com/feathersjs/feathers/compare/v4.0.0-pre.3...v4.0.0-pre.4) (2019-07-05)


### Bug Fixes

* Updated typings for ServiceMethods ([#1409](https://github.com/feathersjs/feathers/issues/1409)) ([b5ee7e2](https://github.com/feathersjs/feathers/commit/b5ee7e2))





# [4.0.0-pre.3](https://github.com/feathersjs/feathers/compare/v4.0.0-pre.2...v4.0.0-pre.3) (2019-06-01)


### Bug Fixes

* Make oAuth paths more consistent and improve authentication client ([#1377](https://github.com/feathersjs/feathers/issues/1377)) ([adb2543](https://github.com/feathersjs/feathers/commit/adb2543))
* Set authenticated: true after successful authentication ([#1367](https://github.com/feathersjs/feathers/issues/1367)) ([9918cff](https://github.com/feathersjs/feathers/commit/9918cff))
* Typings fix and improvements. ([#1364](https://github.com/feathersjs/feathers/issues/1364)) ([515b916](https://github.com/feathersjs/feathers/commit/515b916))
* Update dependencies and fix tests ([#1373](https://github.com/feathersjs/feathers/issues/1373)) ([d743a7f](https://github.com/feathersjs/feathers/commit/d743a7f))





# [4.0.0-pre.2](https://github.com/feathersjs/feathers/compare/v4.0.0-pre.1...v4.0.0-pre.2) (2019-05-15)


### Bug Fixes

* Throw NotAuthenticated on token verification errors ([#1357](https://github.com/feathersjs/feathers/issues/1357)) ([e0120df](https://github.com/feathersjs/feathers/commit/e0120df))





# [4.0.0-pre.1](https://github.com/feathersjs/feathers/compare/v4.0.0-pre.0...v4.0.0-pre.1) (2019-05-08)


### Bug Fixes

* Always require strategy parameter in authentication ([#1327](https://github.com/feathersjs/feathers/issues/1327)) ([d4a8021](https://github.com/feathersjs/feathers/commit/d4a8021))
* Bring back params.authenticated ([#1317](https://github.com/feathersjs/feathers/issues/1317)) ([a0ffd5e](https://github.com/feathersjs/feathers/commit/a0ffd5e))
* Improve authentication parameter handling ([#1333](https://github.com/feathersjs/feathers/issues/1333)) ([6e77204](https://github.com/feathersjs/feathers/commit/6e77204))
* Merge httpStrategies and authStrategies option ([#1308](https://github.com/feathersjs/feathers/issues/1308)) ([afa4d55](https://github.com/feathersjs/feathers/commit/afa4d55))
* Rename jwtStrategies option to authStrategies ([#1305](https://github.com/feathersjs/feathers/issues/1305)) ([4aee151](https://github.com/feathersjs/feathers/commit/4aee151))


### Features

* Change and *JWT methods to *accessToken ([#1304](https://github.com/feathersjs/feathers/issues/1304)) ([5ac826b](https://github.com/feathersjs/feathers/commit/5ac826b))





# [4.0.0-pre.0](https://github.com/feathersjs/feathers/compare/v3.2.0-pre.1...v4.0.0-pre.0) (2019-04-21)


### Bug Fixes

* Added path and method in to express request for passport ([#1112](https://github.com/feathersjs/feathers/issues/1112)) ([afa1cb4](https://github.com/feathersjs/feathers/commit/afa1cb4))
* Authentication core improvements ([#1260](https://github.com/feathersjs/feathers/issues/1260)) ([c5dc7a2](https://github.com/feathersjs/feathers/commit/c5dc7a2))
* Improve JWT authentication option handling ([#1261](https://github.com/feathersjs/feathers/issues/1261)) ([31b956b](https://github.com/feathersjs/feathers/commit/31b956b))
* Make Mocha a proper devDependency for every repository ([#1053](https://github.com/feathersjs/feathers/issues/1053)) ([9974803](https://github.com/feathersjs/feathers/commit/9974803))
* Only merge authenticated property on update ([8a564f7](https://github.com/feathersjs/feathers/commit/8a564f7))
* reduce authentication connection hook complexity and remove unnecessary checks ([fa94b2f](https://github.com/feathersjs/feathers/commit/fa94b2f))
* Update all dependencies to latest ([#1206](https://github.com/feathersjs/feathers/issues/1206)) ([e51e0f6](https://github.com/feathersjs/feathers/commit/e51e0f6))
* **authentication:** Fall back when req.app is not the application when emitting events ([#1185](https://github.com/feathersjs/feathers/issues/1185)) ([6a534f0](https://github.com/feathersjs/feathers/commit/6a534f0))
* Update adapter common tests ([#1135](https://github.com/feathersjs/feathers/issues/1135)) ([8166dda](https://github.com/feathersjs/feathers/commit/8166dda))
* **docs/new-features:** syntax highlighting ([#347](https://github.com/feathersjs/feathers/issues/347)) ([4ab7c95](https://github.com/feathersjs/feathers/commit/4ab7c95))
* **package:** update @feathersjs/commons to version 2.0.0 ([#692](https://github.com/feathersjs/feathers/issues/692)) ([ca665ab](https://github.com/feathersjs/feathers/commit/ca665ab))
* **package:** update debug to version 3.0.0 ([#555](https://github.com/feathersjs/feathers/issues/555)) ([f788804](https://github.com/feathersjs/feathers/commit/f788804))
* **package:** update jsonwebtoken to version 8.0.0 ([#567](https://github.com/feathersjs/feathers/issues/567)) ([6811626](https://github.com/feathersjs/feathers/commit/6811626))
* **package:** update ms to version 2.0.0 ([#509](https://github.com/feathersjs/feathers/issues/509)) ([7e4b0b6](https://github.com/feathersjs/feathers/commit/7e4b0b6))
* **package:** update passport to version 0.4.0 ([#558](https://github.com/feathersjs/feathers/issues/558)) ([dcb14a5](https://github.com/feathersjs/feathers/commit/dcb14a5))


### Features

* @feathersjs/authentication-oauth ([#1299](https://github.com/feathersjs/feathers/issues/1299)) ([656bae7](https://github.com/feathersjs/feathers/commit/656bae7))
* Add AuthenticationBaseStrategy and make authentication option handling more explicit ([#1284](https://github.com/feathersjs/feathers/issues/1284)) ([2667d92](https://github.com/feathersjs/feathers/commit/2667d92))
* Add TypeScript definitions ([#1275](https://github.com/feathersjs/feathers/issues/1275)) ([9dd6713](https://github.com/feathersjs/feathers/commit/9dd6713))
* Authentication v3 core server implementation ([#1205](https://github.com/feathersjs/feathers/issues/1205)) ([1bd7591](https://github.com/feathersjs/feathers/commit/1bd7591))
* Authentication v3 local authentication ([#1211](https://github.com/feathersjs/feathers/issues/1211)) ([0fa5f7c](https://github.com/feathersjs/feathers/commit/0fa5f7c))
* Remove (hook, next) signature and SKIP support ([#1269](https://github.com/feathersjs/feathers/issues/1269)) ([211c0f8](https://github.com/feathersjs/feathers/commit/211c0f8))
* Support params symbol to skip authenticate hook ([#1296](https://github.com/feathersjs/feathers/issues/1296)) ([d16cf4d](https://github.com/feathersjs/feathers/commit/d16cf4d))


### BREAKING CHANGES

* Update authentication strategies for @feathersjs/authentication v3





## [2.1.16](https://github.com/feathersjs/feathers/compare/@feathersjs/authentication@2.1.15...@feathersjs/authentication@2.1.16) (2019-01-26)


### Bug Fixes

* **authentication:** Fall back when req.app is not the application when emitting events ([#1185](https://github.com/feathersjs/feathers/issues/1185)) ([6a534f0](https://github.com/feathersjs/feathers/commit/6a534f0))





## [2.1.15](https://github.com/feathersjs/feathers/compare/@feathersjs/authentication@2.1.14...@feathersjs/authentication@2.1.15) (2019-01-02)


### Bug Fixes

* Update adapter common tests ([#1135](https://github.com/feathersjs/feathers/issues/1135)) ([8166dda](https://github.com/feathersjs/feathers/commit/8166dda))





<a name="2.1.14"></a>
## [2.1.14](https://github.com/feathersjs/feathers/compare/@feathersjs/authentication@2.1.13...@feathersjs/authentication@2.1.14) (2018-12-16)


### Bug Fixes

* Added path and method in to express request for passport ([#1112](https://github.com/feathersjs/feathers/issues/1112)) ([afa1cb4](https://github.com/feathersjs/feathers/commit/afa1cb4))





<a name="2.1.13"></a>
## [2.1.13](https://github.com/feathersjs/feathers/compare/@feathersjs/authentication@2.1.12...@feathersjs/authentication@2.1.13) (2018-10-26)

**Note:** Version bump only for package @feathersjs/authentication





<a name="2.1.12"></a>
## [2.1.12](https://github.com/feathersjs/feathers/compare/@feathersjs/authentication@2.1.11...@feathersjs/authentication@2.1.12) (2018-10-25)


### Bug Fixes

* Make Mocha a proper devDependency for every repository ([#1053](https://github.com/feathersjs/feathers/issues/1053)) ([9974803](https://github.com/feathersjs/feathers/commit/9974803))
* Only merge authenticated property on update ([8a564f7](https://github.com/feathersjs/feathers/commit/8a564f7))





<a name="2.1.11"></a>
## [2.1.11](https://github.com/feathersjs/feathers/compare/@feathersjs/authentication@2.1.10...@feathersjs/authentication@2.1.11) (2018-09-21)

**Note:** Version bump only for package @feathersjs/authentication





<a name="2.1.10"></a>
## [2.1.10](https://github.com/feathersjs/feathers/compare/@feathersjs/authentication@2.1.9...@feathersjs/authentication@2.1.10) (2018-09-17)

**Note:** Version bump only for package @feathersjs/authentication





<a name="2.1.9"></a>
## [2.1.9](https://github.com/feathersjs/feathers/compare/@feathersjs/authentication@2.1.8...@feathersjs/authentication@2.1.9) (2018-09-02)

**Note:** Version bump only for package @feathersjs/authentication

<a name="2.1.8"></a>
## 2.1.8

- Migrate to Monorepo ([feathers#462](https://github.com/feathersjs/feathers/issues/462))

## [v2.1.7](https://github.com/feathersjs/authentication/tree/v2.1.7) (2018-06-29)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v2.1.6...v2.1.7)

**Fixed bugs:**

- XXXOrRestrict undermines provider \(security\) logic [\#395](https://github.com/feathersjs/authentication/issues/395)

**Closed issues:**

- Customize response of authentication service [\#679](https://github.com/feathersjs/authentication/issues/679)
- hook.params.user is null using REST [\#678](https://github.com/feathersjs/authentication/issues/678)
- Can't store JWT token to cookie on REST client [\#676](https://github.com/feathersjs/authentication/issues/676)
- Is there a way to get req.user without using the authentication middleware? [\#675](https://github.com/feathersjs/authentication/issues/675)

**Merged pull requests:**

- Remove subject from the JWT verification options [\#686](https://github.com/feathersjs/authentication/pull/686) ([rasendubi](https://github.com/rasendubi))
- Replaced feathers.static with express.static [\#685](https://github.com/feathersjs/authentication/pull/685) ([georgehorrell](https://github.com/georgehorrell))
- Remove dependency on Express and Express middleware [\#683](https://github.com/feathersjs/authentication/pull/683) ([daffl](https://github.com/daffl))
- Update sinon to the latest version 🚀 [\#681](https://github.com/feathersjs/authentication/pull/681) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))

## [v2.1.6](https://github.com/feathersjs/authentication/tree/v2.1.6) (2018-06-01)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v2.1.5...v2.1.6)

**Closed issues:**

- Authentication local strategy not working with a Custom User service [\#672](https://github.com/feathersjs/authentication/issues/672)
- CLI command bug: 'Feathers generate authentication' produces bad working 'users' service [\#670](https://github.com/feathersjs/authentication/issues/670)
- config\default.json generated without callbackURL config needed to set redirect URL for Google Outh2 [\#669](https://github.com/feathersjs/authentication/issues/669)
- HELP WANTED: Authentication strategy 'jwt' is not registered. [\#668](https://github.com/feathersjs/authentication/issues/668)
- Authenticate shows error: No auth token [\#667](https://github.com/feathersjs/authentication/issues/667)
- authentication - Method: remove [\#662](https://github.com/feathersjs/authentication/issues/662)
- NotAuthenticated: jwt expired [\#633](https://github.com/feathersjs/authentication/issues/633)
- Authentication via phone number [\#616](https://github.com/feathersjs/authentication/issues/616)
- Persist auth tokens on db [\#569](https://github.com/feathersjs/authentication/issues/569)
- Tighter integration with feathers-authentication-management [\#393](https://github.com/feathersjs/authentication/issues/393)

**Merged pull requests:**

- Fix tests to work with latest Sinon [\#674](https://github.com/feathersjs/authentication/pull/674) ([daffl](https://github.com/daffl))
- add option to allowUnauthenticated [\#599](https://github.com/feathersjs/authentication/pull/599) ([MichaelErmer](https://github.com/MichaelErmer))

## [v2.1.5](https://github.com/feathersjs/authentication/tree/v2.1.5) (2018-04-16)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v2.1.4...v2.1.5)

**Closed issues:**

- feathersjs Invalid token: expired [\#661](https://github.com/feathersjs/authentication/issues/661)
- Safari and iOS facebook login can't redirect back, but others can. [\#651](https://github.com/feathersjs/authentication/issues/651)

**Merged pull requests:**

- Remove payload and user entity on logout. [\#665](https://github.com/feathersjs/authentication/pull/665) ([bertho-zero](https://github.com/bertho-zero))

## [v2.1.4](https://github.com/feathersjs/authentication/tree/v2.1.4) (2018-04-12)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v2.1.3...v2.1.4)

**Closed issues:**

- Column "createdAt" does not exist" in Autentication [\#660](https://github.com/feathersjs/authentication/issues/660)
- How to make a user automatically logined on server side? [\#659](https://github.com/feathersjs/authentication/issues/659)
- authentication-jwt functional example [\#657](https://github.com/feathersjs/authentication/issues/657)
- "No auth token" with auth0 when following the guide [\#655](https://github.com/feathersjs/authentication/issues/655)
- Service returns \[No Auth Token\] same by passing Authorization Token on HEADER [\#641](https://github.com/feathersjs/authentication/issues/641)

**Merged pull requests:**

- Throw an error for unavailable strategy [\#663](https://github.com/feathersjs/authentication/pull/663) ([daffl](https://github.com/daffl))
- Update sinon to the latest version 🚀 [\#656](https://github.com/feathersjs/authentication/pull/656) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))

## [v2.1.3](https://github.com/feathersjs/authentication/tree/v2.1.3) (2018-03-16)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v2.1.2...v2.1.3)

**Closed issues:**

- ts [\#647](https://github.com/feathersjs/authentication/issues/647)
- Using /auth/facebook gives a 404 from vue-router [\#643](https://github.com/feathersjs/authentication/issues/643)
- Crash after upgrade to feathersjs v3 [\#642](https://github.com/feathersjs/authentication/issues/642)
- SameSite cookie option [\#640](https://github.com/feathersjs/authentication/issues/640)
- context.params.user is empty object [\#635](https://github.com/feathersjs/authentication/issues/635)
- Token is undefined for authenticated user [\#500](https://github.com/feathersjs/authentication/issues/500)
- 1.x: logout timers need to be moved [\#467](https://github.com/feathersjs/authentication/issues/467)

**Merged pull requests:**

- Merge auk to master [\#653](https://github.com/feathersjs/authentication/pull/653) ([wnxhaja](https://github.com/wnxhaja))
- Update ws to the latest version 🚀 [\#645](https://github.com/feathersjs/authentication/pull/645) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Update sinon-chai to the latest version 🚀 [\#644](https://github.com/feathersjs/authentication/pull/644) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))

## [v2.1.2](https://github.com/feathersjs/authentication/tree/v2.1.2) (2018-02-14)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v2.1.1...v2.1.2)

**Fixed bugs:**

- hook failed with auth & sync [\#540](https://github.com/feathersjs/authentication/issues/540)
- JWT Cookie [\#389](https://github.com/feathersjs/authentication/issues/389)

**Closed issues:**

- forgot password [\#638](https://github.com/feathersjs/authentication/issues/638)
- registered many authentication services [\#634](https://github.com/feathersjs/authentication/issues/634)
- TypeError: Cannot read property '\_strategy' of undefined [\#632](https://github.com/feathersjs/authentication/issues/632)
- How to change 5000ms timeout? [\#628](https://github.com/feathersjs/authentication/issues/628)
- cookie reused from server in SSR app [\#619](https://github.com/feathersjs/authentication/issues/619)
- Express middleware not setCookie [\#617](https://github.com/feathersjs/authentication/issues/617)
- Server to Server Authentication Question [\#612](https://github.com/feathersjs/authentication/issues/612)
- No way to share token between socket-rest-express  [\#607](https://github.com/feathersjs/authentication/issues/607)
- 404 when accessing route using customer authentication [\#579](https://github.com/feathersjs/authentication/issues/579)
- \[question\] is it possible to protect by role a create method? [\#564](https://github.com/feathersjs/authentication/issues/564)
- Authentication with server-side rendering [\#560](https://github.com/feathersjs/authentication/issues/560)
- Problem authenticating using REST middleware [\#495](https://github.com/feathersjs/authentication/issues/495)
- A supposed way to auth requests from SSR to Feathers API [\#469](https://github.com/feathersjs/authentication/issues/469)
- rename `app.authenticate\(\)` to `app.\_authenticate\(\)` [\#468](https://github.com/feathersjs/authentication/issues/468)

**Merged pull requests:**

- Delete slack link [\#637](https://github.com/feathersjs/authentication/pull/637) ([vodniciarv](https://github.com/vodniciarv))
- Update @feathersjs/authentication-jwt to the latest version 🚀 [\#631](https://github.com/feathersjs/authentication/pull/631) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Update mocha to the latest version 🚀 [\#629](https://github.com/feathersjs/authentication/pull/629) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Update ws to the latest version 🚀 [\#625](https://github.com/feathersjs/authentication/pull/625) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Options merged [\#611](https://github.com/feathersjs/authentication/pull/611) ([Makingweb](https://github.com/Makingweb))

## [v2.1.1](https://github.com/feathersjs/authentication/tree/v2.1.1) (2018-01-03)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v2.1.0...v2.1.1)

**Closed issues:**

- Deleted user successfully signs in using JWT [\#615](https://github.com/feathersjs/authentication/issues/615)
- Feathers.authenticate gives window undefined \(server-rendered\) [\#573](https://github.com/feathersjs/authentication/issues/573)
- Be careful with discard\('password'\) in user [\#434](https://github.com/feathersjs/authentication/issues/434)

**Merged pull requests:**

- Update readme to correspond with latest release [\#621](https://github.com/feathersjs/authentication/pull/621) ([daffl](https://github.com/daffl))
- Update semistandard to the latest version 🚀 [\#620](https://github.com/feathersjs/authentication/pull/620) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Update mongodb to the latest version 🚀 [\#618](https://github.com/feathersjs/authentication/pull/618) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))

## [v2.1.0](https://github.com/feathersjs/authentication/tree/v2.1.0) (2017-12-06)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v2.0.1...v2.1.0)

**Closed issues:**

- Method "Remove" from Authentication Service gives Internal Server Error when using JWT Authentication with Cookies. [\#606](https://github.com/feathersjs/authentication/issues/606)
- Anonymous Authentication fails over Socket.io [\#457](https://github.com/feathersjs/authentication/issues/457)

**Merged pull requests:**

- Always prevent publishing of authentication events [\#614](https://github.com/feathersjs/authentication/pull/614) ([daffl](https://github.com/daffl))
- Update feathers-memory to the latest version 🚀 [\#613](https://github.com/feathersjs/authentication/pull/613) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))

## [v2.0.1](https://github.com/feathersjs/authentication/tree/v2.0.1) (2017-11-16)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v2.0.0...v2.0.1)

**Merged pull requests:**

- Add default export for better ES module \(TypeScript\) compatibility [\#605](https://github.com/feathersjs/authentication/pull/605) ([daffl](https://github.com/daffl))

## [v2.0.0](https://github.com/feathersjs/authentication/tree/v2.0.0) (2017-11-09)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.3.1...v2.0.0)

**Closed issues:**

- is there a way to detect if the token used is correct or not ? [\#601](https://github.com/feathersjs/authentication/issues/601)
- option for non-JWT based session [\#597](https://github.com/feathersjs/authentication/issues/597)

**Merged pull requests:**

- Update nsp to the latest version 🚀 [\#603](https://github.com/feathersjs/authentication/pull/603) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))

## [v1.3.1](https://github.com/feathersjs/authentication/tree/v1.3.1) (2017-11-03)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.4.1...v1.3.1)

**Merged pull requests:**

- Only set the JWT UUID if it is not already set [\#600](https://github.com/feathersjs/authentication/pull/600) ([daffl](https://github.com/daffl))

## [v1.4.1](https://github.com/feathersjs/authentication/tree/v1.4.1) (2017-11-01)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.4.0...v1.4.1)

**Merged pull requests:**

- Update dependencies for release [\#598](https://github.com/feathersjs/authentication/pull/598) ([daffl](https://github.com/daffl))
- Finalize v3 dependency updates [\#596](https://github.com/feathersjs/authentication/pull/596) ([daffl](https://github.com/daffl))
- Update Codeclimate coverage token [\#595](https://github.com/feathersjs/authentication/pull/595) ([daffl](https://github.com/daffl))

## [v1.4.0](https://github.com/feathersjs/authentication/tree/v1.4.0) (2017-10-25)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.3.0...v1.4.0)

**Closed issues:**

- An in-range update of socket.io-client is breaking the build 🚨 [\#588](https://github.com/feathersjs/authentication/issues/588)
- An in-range update of feathers-hooks is breaking the build 🚨 [\#587](https://github.com/feathersjs/authentication/issues/587)

**Merged pull requests:**

- Move to npm scope [\#594](https://github.com/feathersjs/authentication/pull/594) ([daffl](https://github.com/daffl))
- Update to Feathers v3 \(Buzzard\) [\#592](https://github.com/feathersjs/authentication/pull/592) ([daffl](https://github.com/daffl))
- Update to new plugin infrastructure [\#591](https://github.com/feathersjs/authentication/pull/591) ([daffl](https://github.com/daffl))

## [v1.3.0](https://github.com/feathersjs/authentication/tree/v1.3.0) (2017-10-24)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.7.13...v1.3.0)

**Merged pull requests:**

- updating the codeclimate setup [\#589](https://github.com/feathersjs/authentication/pull/589) ([ekryski](https://github.com/ekryski))

## [v0.7.13](https://github.com/feathersjs/authentication/tree/v0.7.13) (2017-10-23)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.2.7...v0.7.13)

**Closed issues:**

- Error authenticating! Error: Token provided to verifyJWT is missing or not a string ? [\#584](https://github.com/feathersjs/authentication/issues/584)
- Visual Studio Code  Debug no authentication  [\#583](https://github.com/feathersjs/authentication/issues/583)
- \[Feature Request\] Cloud DB's [\#581](https://github.com/feathersjs/authentication/issues/581)
- Request doesn't contain any headers when user service requested [\#578](https://github.com/feathersjs/authentication/issues/578)
- No way to pass Options to auth.express.authenticate. Needed for Google API refreshToken [\#576](https://github.com/feathersjs/authentication/issues/576)
- /auth/google 404 Not Found [\#574](https://github.com/feathersjs/authentication/issues/574)
- unique email not working while create [\#572](https://github.com/feathersjs/authentication/issues/572)
- authentication service not return token jwt [\#571](https://github.com/feathersjs/authentication/issues/571)
- typo in jwt default options [\#570](https://github.com/feathersjs/authentication/issues/570)
- Generate new app, Google-only auth, throws error [\#568](https://github.com/feathersjs/authentication/issues/568)
- An in-range update of feathers is breaking the build 🚨 [\#565](https://github.com/feathersjs/authentication/issues/565)
- Documentation not understanding [\#563](https://github.com/feathersjs/authentication/issues/563)
- Checking hook.params.headers.authorization [\#552](https://github.com/feathersjs/authentication/issues/552)
- Ability to send token as part of URL [\#546](https://github.com/feathersjs/authentication/issues/546)
- Anonymous Authentication [\#544](https://github.com/feathersjs/authentication/issues/544)
- Quote Error [\#519](https://github.com/feathersjs/authentication/issues/519)
- \[example\] CustomStrategy using passport-custom [\#516](https://github.com/feathersjs/authentication/issues/516)
- \[Epic\] Auth 2.0.0 [\#513](https://github.com/feathersjs/authentication/issues/513)
- ID set to null - Unable to delete with customer ID field. [\#422](https://github.com/feathersjs/authentication/issues/422)
- Prefixing socket events [\#418](https://github.com/feathersjs/authentication/issues/418)
- Passwordless auth [\#409](https://github.com/feathersjs/authentication/issues/409)
- How to authenticate the application client? not only the users [\#405](https://github.com/feathersjs/authentication/issues/405)
- Multi-factor Local Auth [\#5](https://github.com/feathersjs/authentication/issues/5)

**Merged pull requests:**

- Features/typescript fix [\#585](https://github.com/feathersjs/authentication/pull/585) ([TimMensch](https://github.com/TimMensch))
- Update mocha to the latest version 🚀 [\#582](https://github.com/feathersjs/authentication/pull/582) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Update sinon to the latest version 🚀 [\#580](https://github.com/feathersjs/authentication/pull/580) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Update jsonwebtoken to the latest version 🚀 [\#567](https://github.com/feathersjs/authentication/pull/567) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Include Babel Polyfill for Node 4 [\#566](https://github.com/feathersjs/authentication/pull/566) ([daffl](https://github.com/daffl))
- Update passport to the latest version 🚀 [\#558](https://github.com/feathersjs/authentication/pull/558) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Revert "Make feathers-authentication match security documents" [\#556](https://github.com/feathersjs/authentication/pull/556) ([ekryski](https://github.com/ekryski))
- Update debug to the latest version 🚀 [\#555](https://github.com/feathersjs/authentication/pull/555) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Make feathers-authentication match security documents [\#554](https://github.com/feathersjs/authentication/pull/554) ([micaksica2](https://github.com/micaksica2))
- Update sinon to the latest version 🚀 [\#551](https://github.com/feathersjs/authentication/pull/551) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Update ws to the latest version 🚀 [\#549](https://github.com/feathersjs/authentication/pull/549) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Update chai to the latest version 🚀 [\#543](https://github.com/feathersjs/authentication/pull/543) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- adding a default jwt uuid. Refs \#513 [\#539](https://github.com/feathersjs/authentication/pull/539) ([ekryski](https://github.com/ekryski))
- Refresh token must have a user ID [\#419](https://github.com/feathersjs/authentication/pull/419) ([francisco-sanchez-molina](https://github.com/francisco-sanchez-molina))

## [v1.2.7](https://github.com/feathersjs/authentication/tree/v1.2.7) (2017-07-11)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.2.6...v1.2.7)

**Closed issues:**

- Connection without password [\#541](https://github.com/feathersjs/authentication/issues/541)
- email in lower case ? [\#538](https://github.com/feathersjs/authentication/issues/538)
- Im unable to ping feathers server from react native.  [\#537](https://github.com/feathersjs/authentication/issues/537)
- whats the official way to open cors in feather ? [\#536](https://github.com/feathersjs/authentication/issues/536)
- Error options.service does not exist after initial auth setup [\#535](https://github.com/feathersjs/authentication/issues/535)
- LogoutTimer not being cleared correctly [\#532](https://github.com/feathersjs/authentication/issues/532)
- logoutTimer causing early logouts [\#404](https://github.com/feathersjs/authentication/issues/404)

**Merged pull requests:**

- fixed meta undefined error [\#542](https://github.com/feathersjs/authentication/pull/542) ([markacola](https://github.com/markacola))

## [v1.2.6](https://github.com/feathersjs/authentication/tree/v1.2.6) (2017-06-22)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.2.5...v1.2.6)

**Closed issues:**

- OAuth 2 login for cordova [\#530](https://github.com/feathersjs/authentication/issues/530)

**Merged pull requests:**

- Change cleartimeout\(\) to lt.clearTimeout\(\) [\#534](https://github.com/feathersjs/authentication/pull/534) ([wnxhaja](https://github.com/wnxhaja))
- Update feathers-authentication-local to the latest version 🚀 [\#533](https://github.com/feathersjs/authentication/pull/533) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))

## [v1.2.5](https://github.com/feathersjs/authentication/tree/v1.2.5) (2017-06-21)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.2.4...v1.2.5)

**Closed issues:**

- Cannot read property 'user' of undefined - lib\socket\update-entity.js:26:104 [\#529](https://github.com/feathersjs/authentication/issues/529)
- Provider is undefined when using restrictToRoles [\#525](https://github.com/feathersjs/authentication/issues/525)
- How to make a request to an Endpoint that requires authentication from nodejs? [\#523](https://github.com/feathersjs/authentication/issues/523)

**Merged pull requests:**

- fixes several issues with update-entity w/ test cases [\#531](https://github.com/feathersjs/authentication/pull/531) ([jerfowler](https://github.com/jerfowler))

## [v1.2.4](https://github.com/feathersjs/authentication/tree/v1.2.4) (2017-06-08)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.2.3...v1.2.4)

**Fixed bugs:**

- User \(Entity\) needs to be updated on the socket after authentication [\#293](https://github.com/feathersjs/authentication/issues/293)

**Closed issues:**

- Express Middleware local -\> jwt does not authorize on redirect [\#518](https://github.com/feathersjs/authentication/issues/518)
- Issue with feathers-authentication [\#512](https://github.com/feathersjs/authentication/issues/512)
- User Authentication Missing Credentials error \(and subsequent nav authorization\) [\#508](https://github.com/feathersjs/authentication/issues/508)
- passport log failure [\#505](https://github.com/feathersjs/authentication/issues/505)
- authenticate with a custom username field \(rather than email\) [\#502](https://github.com/feathersjs/authentication/issues/502)
- app.get\('auth'\) vs app.get\('authentication'\) [\#497](https://github.com/feathersjs/authentication/issues/497)
- Can't get success authorization with pure feathers server [\#491](https://github.com/feathersjs/authentication/issues/491)

**Merged pull requests:**

- Test and fix for authenticate event with invalid data [\#524](https://github.com/feathersjs/authentication/pull/524) ([daffl](https://github.com/daffl))
- Remove hook.data.payload [\#522](https://github.com/feathersjs/authentication/pull/522) ([marshallswain](https://github.com/marshallswain))
- Update socket entity [\#521](https://github.com/feathersjs/authentication/pull/521) ([marshallswain](https://github.com/marshallswain))
- Made each option, optional [\#515](https://github.com/feathersjs/authentication/pull/515) ([cranesandcaff](https://github.com/cranesandcaff))
- Add feathers-authentication-hooks in readme [\#510](https://github.com/feathersjs/authentication/pull/510) ([bertho-zero](https://github.com/bertho-zero))
- Update ms to the latest version 🚀 [\#509](https://github.com/feathersjs/authentication/pull/509) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Fix default authentication config keys [\#506](https://github.com/feathersjs/authentication/pull/506) ([ekryski](https://github.com/ekryski))

## [v1.2.3](https://github.com/feathersjs/authentication/tree/v1.2.3) (2017-05-10)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.2.2...v1.2.3)

**Closed issues:**

- Validating custom express routes [\#498](https://github.com/feathersjs/authentication/issues/498)
- Payload won't include userId when logging in with stored localStorage token [\#496](https://github.com/feathersjs/authentication/issues/496)
- How to send oauth token authentication to another client server [\#493](https://github.com/feathersjs/authentication/issues/493)
- Unhandled Promise Rejection error. [\#489](https://github.com/feathersjs/authentication/issues/489)
- No Auth token on authentication resource [\#488](https://github.com/feathersjs/authentication/issues/488)
- How to verify JWT in feathers issued by another feathers instance ? [\#484](https://github.com/feathersjs/authentication/issues/484)
- hook.params.user [\#483](https://github.com/feathersjs/authentication/issues/483)
- Overriding JWT's expiresIn with a value more than 20d prevents users from signing in [\#458](https://github.com/feathersjs/authentication/issues/458)

**Merged pull requests:**

- Update feathers-socketio to the latest version 🚀 [\#503](https://github.com/feathersjs/authentication/pull/503) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Update socket.io-client to the latest version 🚀 [\#501](https://github.com/feathersjs/authentication/pull/501) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Fix issue with very large token timeout. [\#499](https://github.com/feathersjs/authentication/pull/499) ([asdacap](https://github.com/asdacap))
- Typo [\#492](https://github.com/feathersjs/authentication/pull/492) ([wdmtech](https://github.com/wdmtech))
- Update migrating.md [\#490](https://github.com/feathersjs/authentication/pull/490) ([MichaelErmer](https://github.com/MichaelErmer))
- Update semistandard to the latest version 🚀 [\#487](https://github.com/feathersjs/authentication/pull/487) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Update feathers-hooks to the latest version 🚀 [\#485](https://github.com/feathersjs/authentication/pull/485) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Update dependencies to enable Greenkeeper 🌴 [\#482](https://github.com/feathersjs/authentication/pull/482) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))

## [v1.2.2](https://github.com/feathersjs/authentication/tree/v1.2.2) (2017-04-12)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.2.1...v1.2.2)

**Fixed bugs:**

- accessToken not being used when provided by client over socketio [\#400](https://github.com/feathersjs/authentication/issues/400)

**Closed issues:**

- Incompatible old client dependency [\#479](https://github.com/feathersjs/authentication/issues/479)
- Using feathers-authentication-client for an existing API? [\#478](https://github.com/feathersjs/authentication/issues/478)
- app.authenticate error : UnhandledPromiseRejectionWarning: Unhandled promise rejection \(rejection id: 2\): \* Error \* [\#476](https://github.com/feathersjs/authentication/issues/476)
- Make `socket.feathers` data available in authentication hooks [\#475](https://github.com/feathersjs/authentication/issues/475)
- Allow the authenticate hook to be called with no parameters [\#473](https://github.com/feathersjs/authentication/issues/473)
- Authenticate : How to return more infos ? [\#471](https://github.com/feathersjs/authentication/issues/471)

**Merged pull requests:**

- Use latest version of feathers-authentication-client [\#480](https://github.com/feathersjs/authentication/pull/480) ([daffl](https://github.com/daffl))
- Resolves \#475 - Socket params are made available to authentication hooks [\#477](https://github.com/feathersjs/authentication/pull/477) ([thomas-p-wilson](https://github.com/thomas-p-wilson))

## [v1.2.1](https://github.com/feathersjs/authentication/tree/v1.2.1) (2017-04-07)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.2.0...v1.2.1)

**Fixed bugs:**

- failureRedirect is never used when using with oauth2 [\#387](https://github.com/feathersjs/authentication/issues/387)

**Closed issues:**

- OAuth guides [\#470](https://github.com/feathersjs/authentication/issues/470)
- app.authenticate not working [\#466](https://github.com/feathersjs/authentication/issues/466)
- how can I logout using local authentication? [\#465](https://github.com/feathersjs/authentication/issues/465)
- How to do Socket.io Authentication [\#462](https://github.com/feathersjs/authentication/issues/462)
- Add event filtering by default \(socket.io\) [\#460](https://github.com/feathersjs/authentication/issues/460)
- Add ability to control if socket is marked as authenticated. [\#448](https://github.com/feathersjs/authentication/issues/448)
- Auth redirect issue [\#425](https://github.com/feathersjs/authentication/issues/425)
- E-mail verification step can be bypassed using Postman or Curl [\#391](https://github.com/feathersjs/authentication/issues/391)
- Example app [\#386](https://github.com/feathersjs/authentication/issues/386)

**Merged pull requests:**

- Allow the cookie to be set if action is not `remove` [\#474](https://github.com/feathersjs/authentication/pull/474) ([marshallswain](https://github.com/marshallswain))

## [v1.2.0](https://github.com/feathersjs/authentication/tree/v1.2.0) (2017-03-23)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.1.1...v1.2.0)

**Fixed bugs:**

- 1.0 authentication service hooks don't run when client uses feathers-socketio [\#455](https://github.com/feathersjs/authentication/issues/455)
- `hook.params.provider` is not set when calling `client.authenticate\(\)` [\#432](https://github.com/feathersjs/authentication/issues/432)
- remove method failed with JsonWebTokenError: invalid token [\#388](https://github.com/feathersjs/authentication/issues/388)

**Closed issues:**

- Token creation has side effect [\#454](https://github.com/feathersjs/authentication/issues/454)
- Question: When is userId set? [\#453](https://github.com/feathersjs/authentication/issues/453)
- How to authenticate SPA? More precisely how does the redirect works?  [\#451](https://github.com/feathersjs/authentication/issues/451)
- POST to auth/facebook for FacebookTokenStrategy 404? [\#447](https://github.com/feathersjs/authentication/issues/447)
- feathers-authentication 1.1.1 `No auth token` [\#445](https://github.com/feathersjs/authentication/issues/445)
- Another readme incorrect and maybe docs to [\#441](https://github.com/feathersjs/authentication/issues/441)
- Readme incorrect and maybe docs to [\#440](https://github.com/feathersjs/authentication/issues/440)
- npm version issue? [\#439](https://github.com/feathersjs/authentication/issues/439)
- setCookie express middleware only works inside hooks [\#438](https://github.com/feathersjs/authentication/issues/438)
- createJWT throws 'secret must provided' [\#437](https://github.com/feathersjs/authentication/issues/437)
- Not useful error message on NotAuthenticated error [\#436](https://github.com/feathersjs/authentication/issues/436)
- Passwordfeld in auth.local does not work as expected [\#435](https://github.com/feathersjs/authentication/issues/435)
- Authentication via REST returns token without finding user on db [\#430](https://github.com/feathersjs/authentication/issues/430)

**Merged pull requests:**

- Filter out all events [\#461](https://github.com/feathersjs/authentication/pull/461) ([daffl](https://github.com/daffl))
- Fix socket auth [\#459](https://github.com/feathersjs/authentication/pull/459) ([marshallswain](https://github.com/marshallswain))
- Fix \#454 Token create has side effect [\#456](https://github.com/feathersjs/authentication/pull/456) ([whollacsek](https://github.com/whollacsek))
- Windows compatible version of the original compile comand with public folder support. [\#442](https://github.com/feathersjs/authentication/pull/442) ([appurist](https://github.com/appurist))
- Add client.js back for consistency [\#433](https://github.com/feathersjs/authentication/pull/433) ([daffl](https://github.com/daffl))
- add string to authenticate \(typescript\) [\#431](https://github.com/feathersjs/authentication/pull/431) ([superbarne](https://github.com/superbarne))
- Add support for Bearer scheme in remove method [\#403](https://github.com/feathersjs/authentication/pull/403) ([boybundit](https://github.com/boybundit))

## [v1.1.1](https://github.com/feathersjs/authentication/tree/v1.1.1) (2017-03-02)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.1.0...v1.1.1)

**Closed issues:**

- Authentication over socket.io never answers [\#428](https://github.com/feathersjs/authentication/issues/428)

**Merged pull requests:**

- Remove lots of hardcoded values for config, and adds the `authenticate` hook [\#427](https://github.com/feathersjs/authentication/pull/427) ([myknbani](https://github.com/myknbani))

## [v1.1.0](https://github.com/feathersjs/authentication/tree/v1.1.0) (2017-03-01)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.0.2...v1.1.0)

**Fixed bugs:**

- Mongo update error after logging into Facebook [\#244](https://github.com/feathersjs/authentication/issues/244)

**Closed issues:**

- Feature Request: Anonymous Authentication Strategy Support [\#423](https://github.com/feathersjs/authentication/issues/423)
- Error is not thrown if token that is provided is invalid [\#421](https://github.com/feathersjs/authentication/issues/421)
- Request body 'token' parameter disappears [\#420](https://github.com/feathersjs/authentication/issues/420)
- Auth2 issue getting JWT token from server when different ports [\#416](https://github.com/feathersjs/authentication/issues/416)
- Cookie-based authentication with XHR is not possible [\#413](https://github.com/feathersjs/authentication/issues/413)
- JWT Authentication setup failing [\#411](https://github.com/feathersjs/authentication/issues/411)
- how to disable service for external usage in version 1.0 [\#410](https://github.com/feathersjs/authentication/issues/410)
- v1.0 is removed from npm? [\#408](https://github.com/feathersjs/authentication/issues/408)
- Make JWT data more configurable [\#407](https://github.com/feathersjs/authentication/issues/407)
- Possible typo [\#406](https://github.com/feathersjs/authentication/issues/406)
- Authentication with an existing database with existing hashed \(md5\) passwords [\#398](https://github.com/feathersjs/authentication/issues/398)
- can modify selected fields only [\#397](https://github.com/feathersjs/authentication/issues/397)
- \[Discussion\] Migrating to 1.0 - hook changes [\#396](https://github.com/feathersjs/authentication/issues/396)
- feathers-authentication 'local' strategy requires token? [\#394](https://github.com/feathersjs/authentication/issues/394)
- JWT for local auth. [\#390](https://github.com/feathersjs/authentication/issues/390)
- Feathers 'Twitter API' style [\#385](https://github.com/feathersjs/authentication/issues/385)
- Missing code in example app [\#383](https://github.com/feathersjs/authentication/issues/383)
- feathers-authentication errors with any view error, and redirects to /auth/failure [\#381](https://github.com/feathersjs/authentication/issues/381)
- what does app.service\('authentication'\).remove\(...\) mean? [\#379](https://github.com/feathersjs/authentication/issues/379)
- Rest Endpoints. [\#375](https://github.com/feathersjs/authentication/issues/375)
- cordova google-plus signUp with id\_token [\#373](https://github.com/feathersjs/authentication/issues/373)
- How to reconnect socket with cookie after page refresh ? [\#372](https://github.com/feathersjs/authentication/issues/372)
- Error: Could not find stored JWT and no authentication strategy was given [\#367](https://github.com/feathersjs/authentication/issues/367)
- "No auth token" using authenticate  strategy: 'jwt' \(v.1.0.0-beta-2\) [\#366](https://github.com/feathersjs/authentication/issues/366)
- Navigating to /auth/\<provider\> twice redirects to /auth/failed [\#344](https://github.com/feathersjs/authentication/issues/344)
- Meteor auth migration guide [\#334](https://github.com/feathersjs/authentication/issues/334)
- Auth 1.0 [\#330](https://github.com/feathersjs/authentication/issues/330)
- RSA token secret [\#309](https://github.com/feathersjs/authentication/issues/309)
- Add option to use bcrypt [\#300](https://github.com/feathersjs/authentication/issues/300)
- Better example of how to change hashing algorithm? \[Question\] [\#289](https://github.com/feathersjs/authentication/issues/289)
- issuer doesn't work [\#284](https://github.com/feathersjs/authentication/issues/284)
- passport auth question [\#274](https://github.com/feathersjs/authentication/issues/274)
- Add support for authenticating active users only [\#259](https://github.com/feathersjs/authentication/issues/259)
- 404 response from populateUser\(\) hook [\#258](https://github.com/feathersjs/authentication/issues/258)
- Responses hang when token.secret is undefined for local authentication [\#249](https://github.com/feathersjs/authentication/issues/249)
- Authentication without password [\#246](https://github.com/feathersjs/authentication/issues/246)
- Fix successRedirect to not override cookie path [\#243](https://github.com/feathersjs/authentication/issues/243)
- Deprecate verifyToken and populateUser hooks in favour of middleware [\#227](https://github.com/feathersjs/authentication/issues/227)
- Authenticating and creating [\#100](https://github.com/feathersjs/authentication/issues/100)
- Add a password service [\#83](https://github.com/feathersjs/authentication/issues/83)

**Merged pull requests:**

- Fix JWT options typo [\#415](https://github.com/feathersjs/authentication/pull/415) ([daffl](https://github.com/daffl))
- Prevent setCookie from mutating authOptions [\#414](https://github.com/feathersjs/authentication/pull/414) ([adrien-k](https://github.com/adrien-k))
- Typescript Definitions [\#412](https://github.com/feathersjs/authentication/pull/412) ([AbraaoAlves](https://github.com/AbraaoAlves))
- Docs for migrating to auth.hooks.authenticate hook [\#399](https://github.com/feathersjs/authentication/pull/399) ([petermikitsh](https://github.com/petermikitsh))
- Typo 'cookie.enable' should be 'cookie.enabled' [\#380](https://github.com/feathersjs/authentication/pull/380) ([whollacsek](https://github.com/whollacsek))
- Docs: Equalize usage of feathers-authenticate [\#378](https://github.com/feathersjs/authentication/pull/378) ([eikaramba](https://github.com/eikaramba))

## [v1.0.2](https://github.com/feathersjs/authentication/tree/v1.0.2) (2016-12-14)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.0.1...v1.0.2)

**Closed issues:**

- successRedirect not redirecting [\#364](https://github.com/feathersjs/authentication/issues/364)

## [v1.0.1](https://github.com/feathersjs/authentication/tree/v1.0.1) (2016-12-14)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.0.0...v1.0.1)

## [v1.0.0](https://github.com/feathersjs/authentication/tree/v1.0.0) (2016-12-14)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.7.12...v1.0.0)

**Fixed bugs:**

- restrictToOwner does not support multi patch, update and remove [\#228](https://github.com/feathersjs/authentication/issues/228)

**Closed issues:**

- auth.express.authenticate got undefined [\#363](https://github.com/feathersjs/authentication/issues/363)
- Non-standard header structure [\#361](https://github.com/feathersjs/authentication/issues/361)
- localEndpoint without local strategy  [\#359](https://github.com/feathersjs/authentication/issues/359)
- Using custom passport strategies [\#356](https://github.com/feathersjs/authentication/issues/356)
- Client-side app.on\('login'\) [\#355](https://github.com/feathersjs/authentication/issues/355)
- Payload limiting on `app.get\('user'\)`? [\#354](https://github.com/feathersjs/authentication/issues/354)
- Authentication token is missing  [\#352](https://github.com/feathersjs/authentication/issues/352)
- \[1.0\] The entity on the socket should pull from the strategy options. [\#348](https://github.com/feathersjs/authentication/issues/348)
- \[1.0\] Only the first failure is returned on auth failure when chaining multiple strategies [\#346](https://github.com/feathersjs/authentication/issues/346)
- Build 0.7.11 does not contain current code on NPMJS [\#342](https://github.com/feathersjs/authentication/issues/342)
-  feathers-authentication branch 0.8 did not work with payload \(tested on socket\) [\#264](https://github.com/feathersjs/authentication/issues/264)
- Add method for updating JWT [\#260](https://github.com/feathersjs/authentication/issues/260)
- 1.0 architecture considerations [\#226](https://github.com/feathersjs/authentication/issues/226)
- Features/RFC [\#213](https://github.com/feathersjs/authentication/issues/213)
- Support access\_token based OAuth2 providers [\#169](https://github.com/feathersjs/authentication/issues/169)
- Support openID [\#154](https://github.com/feathersjs/authentication/issues/154)
- Disable cookie by default if not using OAuth [\#152](https://github.com/feathersjs/authentication/issues/152)
- Add token service tests [\#144](https://github.com/feathersjs/authentication/issues/144)
- Add local service tests [\#143](https://github.com/feathersjs/authentication/issues/143)
- Add OAuth2 service tests [\#142](https://github.com/feathersjs/authentication/issues/142)
- Add OAuth2 integration tests [\#141](https://github.com/feathersjs/authentication/issues/141)
- Add integration tests for custom redirects [\#125](https://github.com/feathersjs/authentication/issues/125)
- Support mobile authentication via OAuth1 [\#47](https://github.com/feathersjs/authentication/issues/47)
- Support OAuth1 [\#42](https://github.com/feathersjs/authentication/issues/42)
- Password-less Local Auth with Email / SMS [\#7](https://github.com/feathersjs/authentication/issues/7)

**Merged pull requests:**

- migrating to semistandard [\#371](https://github.com/feathersjs/authentication/pull/371) ([ekryski](https://github.com/ekryski))
- Logout should always give a response. [\#369](https://github.com/feathersjs/authentication/pull/369) ([marshallswain](https://github.com/marshallswain))
- Clarify that the authenticate hook is required. [\#368](https://github.com/feathersjs/authentication/pull/368) ([marshallswain](https://github.com/marshallswain))
- Fix README example [\#365](https://github.com/feathersjs/authentication/pull/365) ([saiberz](https://github.com/saiberz))
- Remove additional deprecation notice [\#362](https://github.com/feathersjs/authentication/pull/362) ([porsager](https://github.com/porsager))
- fix typo [\#360](https://github.com/feathersjs/authentication/pull/360) ([osenvosem](https://github.com/osenvosem))
- Update feathers-primus to version 2.0.0 🚀 [\#358](https://github.com/feathersjs/authentication/pull/358) ([greenkeeperio-bot](https://github.com/greenkeeperio-bot))
- Create .codeclimate.yml [\#357](https://github.com/feathersjs/authentication/pull/357) ([larkinscott](https://github.com/larkinscott))
- fixing redirect middleware [\#353](https://github.com/feathersjs/authentication/pull/353) ([ekryski](https://github.com/ekryski))
- Remove useless quotes [\#351](https://github.com/feathersjs/authentication/pull/351) ([bertho-zero](https://github.com/bertho-zero))
- A bunch of bug fixes [\#349](https://github.com/feathersjs/authentication/pull/349) ([ekryski](https://github.com/ekryski))
- fix\(docs/new-features\): syntax highlighting [\#347](https://github.com/feathersjs/authentication/pull/347) ([justingreenberg](https://github.com/justingreenberg))
- Update superagent to version 3.0.0 🚀 [\#345](https://github.com/feathersjs/authentication/pull/345) ([greenkeeperio-bot](https://github.com/greenkeeperio-bot))
- Update feathers-memory to version 1.0.0 🚀 [\#343](https://github.com/feathersjs/authentication/pull/343) ([greenkeeperio-bot](https://github.com/greenkeeperio-bot))
- 1.0 Pre-release [\#336](https://github.com/feathersjs/authentication/pull/336) ([ekryski](https://github.com/ekryski))

## [v0.7.12](https://github.com/feathersjs/authentication/tree/v0.7.12) (2016-11-11)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.7.11...v0.7.12)

**Closed issues:**

- App.authenticate uses wrong `this` reference [\#341](https://github.com/feathersjs/authentication/issues/341)
- Getting more done in GitHub with ZenHub [\#331](https://github.com/feathersjs/authentication/issues/331)
- Need help to use feathers authentication storage in vue vuex [\#329](https://github.com/feathersjs/authentication/issues/329)
- How to get user id in hooks? [\#322](https://github.com/feathersjs/authentication/issues/322)
- I checked out my new feathersjs app in another machine, created a new user but I can't log in! [\#320](https://github.com/feathersjs/authentication/issues/320)
- restrict-to-owner throws error when user id is 0 [\#319](https://github.com/feathersjs/authentication/issues/319)
- Not providing sufficient details for an auth provider should not be an error. [\#318](https://github.com/feathersjs/authentication/issues/318)
- \[Question\] Is there a way to verify a user with password? [\#316](https://github.com/feathersjs/authentication/issues/316)
- 0.8.0 beta 1 bug - this is not defined [\#315](https://github.com/feathersjs/authentication/issues/315)
- Client: Document getJWT & verifyJWT [\#313](https://github.com/feathersjs/authentication/issues/313)
- Socket client should automatically auth on reconnect [\#310](https://github.com/feathersjs/authentication/issues/310)
- app.get\('token'\) doesn't work after a browser refresh. [\#303](https://github.com/feathersjs/authentication/issues/303)
- Problem issuing multiple jwt's for the same user [\#302](https://github.com/feathersjs/authentication/issues/302)
- restrict-to-owner does not allow Service.remove\(null\) from internal systems [\#301](https://github.com/feathersjs/authentication/issues/301)
- How to migrate from restrictToOwner to checkPermissions [\#299](https://github.com/feathersjs/authentication/issues/299)
- "username" cannot be used as local strategy usernameField [\#294](https://github.com/feathersjs/authentication/issues/294)
- Bad Hook API Design: Hooks are inconsistent and impure functions [\#288](https://github.com/feathersjs/authentication/issues/288)
- Mutliple 'user' models for authentication [\#282](https://github.com/feathersjs/authentication/issues/282)
- Client should ensure socket.io upgrade is complete before authenticating [\#275](https://github.com/feathersjs/authentication/issues/275)
- JWT is not sent after socket reconnection [\#272](https://github.com/feathersjs/authentication/issues/272)
- 401 after service is moved/refactored [\#270](https://github.com/feathersjs/authentication/issues/270)
- Client side auth should subscribe to user updates so that app.get\('user'\) is fresh [\#195](https://github.com/feathersjs/authentication/issues/195)
- Make oauth2 more general [\#179](https://github.com/feathersjs/authentication/issues/179)
- Add integration tests for custom service endpoints [\#145](https://github.com/feathersjs/authentication/issues/145)
- Create a `requireAuth` wrapper for `verifyToken`, `populateUser`, `restrictToAuth` [\#118](https://github.com/feathersjs/authentication/issues/118)

**Merged pull requests:**

- babel-core@6.18.2 breaks build 🚨 [\#339](https://github.com/feathersjs/authentication/pull/339) ([greenkeeperio-bot](https://github.com/greenkeeperio-bot))
- 👻😱 Node.js 0.10 is unmaintained 😱👻 [\#337](https://github.com/feathersjs/authentication/pull/337) ([greenkeeperio-bot](https://github.com/greenkeeperio-bot))
- restrictToOwner -Fix check for methodNotAllowed [\#335](https://github.com/feathersjs/authentication/pull/335) ([daffl](https://github.com/daffl))
- Implement login and logout events for REST authentication [\#325](https://github.com/feathersjs/authentication/pull/325) ([daffl](https://github.com/daffl))
- Socket.io authentication tests and login logout event [\#324](https://github.com/feathersjs/authentication/pull/324) ([daffl](https://github.com/daffl))
- Reorganization [\#321](https://github.com/feathersjs/authentication/pull/321) ([ekryski](https://github.com/ekryski))
- client: use Authentication class, make `getJWT` and `verifyJWT` async [\#317](https://github.com/feathersjs/authentication/pull/317) ([marshallswain](https://github.com/marshallswain))
- 0.8 client decode jwt [\#314](https://github.com/feathersjs/authentication/pull/314) ([marshallswain](https://github.com/marshallswain))
- Store config at `app.config` [\#312](https://github.com/feathersjs/authentication/pull/312) ([marshallswain](https://github.com/marshallswain))
- Cookies will match jwt expiry by default. [\#308](https://github.com/feathersjs/authentication/pull/308) ([marshallswain](https://github.com/marshallswain))
- Remove permissions hooks and middleware [\#307](https://github.com/feathersjs/authentication/pull/307) ([daffl](https://github.com/daffl))
- First cut for authentication middleware [\#305](https://github.com/feathersjs/authentication/pull/305) ([daffl](https://github.com/daffl))
- 0.8 - OAuth fixes [\#304](https://github.com/feathersjs/authentication/pull/304) ([marshallswain](https://github.com/marshallswain))

## [v0.7.11](https://github.com/feathersjs/authentication/tree/v0.7.11) (2016-09-28)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.7.10...v0.7.11)

**Closed issues:**

- Unable to authenticate with passport-google-oauth20 [\#295](https://github.com/feathersjs/authentication/issues/295)
- "Unauthorized" Response with Hook Data [\#291](https://github.com/feathersjs/authentication/issues/291)
- hashPassword in patch [\#286](https://github.com/feathersjs/authentication/issues/286)
- Mobile App Facebook Login [\#276](https://github.com/feathersjs/authentication/issues/276)
- Socket user should update automatically [\#266](https://github.com/feathersjs/authentication/issues/266)
- Get user outside a service [\#261](https://github.com/feathersjs/authentication/issues/261)

**Merged pull requests:**

- hashPassword fall-through if there's no password [\#287](https://github.com/feathersjs/authentication/pull/287) ([marshallswain](https://github.com/marshallswain))
- Update feathers-memory to version 0.8.0 🚀 [\#285](https://github.com/feathersjs/authentication/pull/285) ([greenkeeperio-bot](https://github.com/greenkeeperio-bot))
- Allow multiple username fields for local auth [\#283](https://github.com/feathersjs/authentication/pull/283) ([sdbondi](https://github.com/sdbondi))

## [v0.7.10](https://github.com/feathersjs/authentication/tree/v0.7.10) (2016-08-31)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.7.9...v0.7.10)

**Fixed bugs:**

- restrictToOwner should not throw an error on mass deletions [\#175](https://github.com/feathersjs/authentication/issues/175)

**Closed issues:**

- Duplicate Email should be rejected by Default [\#281](https://github.com/feathersjs/authentication/issues/281)
- Auth0 & featherjs authorization only [\#277](https://github.com/feathersjs/authentication/issues/277)
- Cannot read property 'scope' of undefined [\#273](https://github.com/feathersjs/authentication/issues/273)
- Socker.js | Custom successHandler [\#271](https://github.com/feathersjs/authentication/issues/271)
- Use feathers-socketio? and rest&socket share session maybe?  [\#269](https://github.com/feathersjs/authentication/issues/269)
- Ability to invalidate old token/session when user login with another machine. [\#267](https://github.com/feathersjs/authentication/issues/267)
- 0.8 authentication before hooks - only ever getting a 401 Unauthorised [\#263](https://github.com/feathersjs/authentication/issues/263)
- REST Middleware breaks local auth [\#262](https://github.com/feathersjs/authentication/issues/262)
- 0.8: Token Service errors on token auth using client [\#254](https://github.com/feathersjs/authentication/issues/254)
- 0.8: Cookies, turning off feathers-session cookie also turns off feathers-jwt cookie. [\#253](https://github.com/feathersjs/authentication/issues/253)
- Any example of how to do refresh token? [\#248](https://github.com/feathersjs/authentication/issues/248)
- Custom Authentication Hooks [\#236](https://github.com/feathersjs/authentication/issues/236)
- Is there an Authenticated Event [\#235](https://github.com/feathersjs/authentication/issues/235)
- Error while using /auth/local [\#233](https://github.com/feathersjs/authentication/issues/233)
- Providing token to feathers.authentication doesn't work [\#230](https://github.com/feathersjs/authentication/issues/230)
- bundled hooks customize errors [\#215](https://github.com/feathersjs/authentication/issues/215)
- Hooks should support a callback for conditionally running [\#210](https://github.com/feathersjs/authentication/issues/210)
- restrictToRoles hook: More complex determination of "owner". [\#205](https://github.com/feathersjs/authentication/issues/205)
- verifyToken hook option to error [\#200](https://github.com/feathersjs/authentication/issues/200)
- Allow using restrictToOwner as an after hook [\#123](https://github.com/feathersjs/authentication/issues/123)

**Merged pull requests:**

- Manually supply an endpoint to the Client authenticate\(\) method [\#278](https://github.com/feathersjs/authentication/pull/278) ([mcnamee](https://github.com/mcnamee))
- Update mocha to version 3.0.0 🚀 [\#257](https://github.com/feathersjs/authentication/pull/257) ([greenkeeperio-bot](https://github.com/greenkeeperio-bot))
- Don’t mix options when signing tokens [\#255](https://github.com/feathersjs/authentication/pull/255) ([marshallswain](https://github.com/marshallswain))
- Attempt to get token right away. [\#252](https://github.com/feathersjs/authentication/pull/252) ([marshallswain](https://github.com/marshallswain))
- Update async to version 2.0.0 🚀 [\#240](https://github.com/feathersjs/authentication/pull/240) ([greenkeeperio-bot](https://github.com/greenkeeperio-bot))
- Creates better way or returning data in a familiar format [\#234](https://github.com/feathersjs/authentication/pull/234) ([codingfriend1](https://github.com/codingfriend1))
- Throws an error if restriction methods are used outside of a find or get hook [\#232](https://github.com/feathersjs/authentication/pull/232) ([codingfriend1](https://github.com/codingfriend1))
- RestrictToOwner now takes an array [\#231](https://github.com/feathersjs/authentication/pull/231) ([sscaff1](https://github.com/sscaff1))
- Adds ability to limit queries unless authenticated and authorized [\#229](https://github.com/feathersjs/authentication/pull/229) ([codingfriend1](https://github.com/codingfriend1))

## [v0.7.9](https://github.com/feathersjs/authentication/tree/v0.7.9) (2016-06-20)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.7.8...v0.7.9)

**Fixed bugs:**

- Calling logout should revoke/blacklist a JWT [\#133](https://github.com/feathersjs/authentication/issues/133)

**Closed issues:**

- Query email rather than oauth provider id on /auth/\<provider\> [\#223](https://github.com/feathersjs/authentication/issues/223)
- Cannot read property \'service\' of undefined [\#222](https://github.com/feathersjs/authentication/issues/222)

**Merged pull requests:**

- added support for hashing passwords when hook.data is an array [\#225](https://github.com/feathersjs/authentication/pull/225) ([eblin](https://github.com/eblin))
- jwt ssl warning [\#214](https://github.com/feathersjs/authentication/pull/214) ([aboutlo](https://github.com/aboutlo))

## [v0.7.8](https://github.com/feathersjs/authentication/tree/v0.7.8) (2016-06-09)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.7.7...v0.7.8)

**Closed issues:**

- Feathers-authentication assumptions [\#220](https://github.com/feathersjs/authentication/issues/220)
- Server-side header option does not accept capital letters [\#218](https://github.com/feathersjs/authentication/issues/218)
- How to figure out why redirect to /auth/failure? [\#217](https://github.com/feathersjs/authentication/issues/217)
- Getting token via REST is not documented [\#216](https://github.com/feathersjs/authentication/issues/216)
- How to use Feathers Client to Authenticate Facebook/Instagram credentials [\#204](https://github.com/feathersjs/authentication/issues/204)
- Remove token from localstorage [\#203](https://github.com/feathersjs/authentication/issues/203)
- Check user password [\#193](https://github.com/feathersjs/authentication/issues/193)
- app.authenticate\(\): Warning: a promise was rejected with a non-error: \[object Object\] [\#191](https://github.com/feathersjs/authentication/issues/191)
- Authentication provider for Facebook Account Kit [\#189](https://github.com/feathersjs/authentication/issues/189)

**Merged pull requests:**

- Lowercase custom header [\#219](https://github.com/feathersjs/authentication/pull/219) ([mmwtsn](https://github.com/mmwtsn))
- mocha@2.5.0 breaks build 🚨 [\#212](https://github.com/feathersjs/authentication/pull/212) ([greenkeeperio-bot](https://github.com/greenkeeperio-bot))
- Small refactoring to simplify structure and remove code duplication [\#209](https://github.com/feathersjs/authentication/pull/209) ([daffl](https://github.com/daffl))
- Use removeItem in the storage on logout [\#208](https://github.com/feathersjs/authentication/pull/208) ([daffl](https://github.com/daffl))
- Misspelled in a comment [\#201](https://github.com/feathersjs/authentication/pull/201) ([tryy3](https://github.com/tryy3))
- Update babel-plugin-add-module-exports to version 0.2.0 🚀 [\#199](https://github.com/feathersjs/authentication/pull/199) ([greenkeeperio-bot](https://github.com/greenkeeperio-bot))

## [v0.7.7](https://github.com/feathersjs/authentication/tree/v0.7.7) (2016-05-05)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.7.6...v0.7.7)

**Fixed bugs:**

- OAuth2 authentication callback failing due to missing property [\#196](https://github.com/feathersjs/authentication/issues/196)

**Merged pull requests:**

- properly handle optional `\_json` property [\#197](https://github.com/feathersjs/authentication/pull/197) ([nyaaao](https://github.com/nyaaao))

## [v0.7.6](https://github.com/feathersjs/authentication/tree/v0.7.6) (2016-05-03)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.7.5...v0.7.6)

**Fixed bugs:**

- Facebook Authentication should do a patch not an update. [\#174](https://github.com/feathersjs/authentication/issues/174)

**Closed issues:**

- Authenticated user  [\#192](https://github.com/feathersjs/authentication/issues/192)
- REST token revoke [\#185](https://github.com/feathersjs/authentication/issues/185)
- TypeError: Cannot read property 'service' of undefined [\#173](https://github.com/feathersjs/authentication/issues/173)
- Optionally Include password in the params.query object passed to User.find\(\) [\#171](https://github.com/feathersjs/authentication/issues/171)
- Pass more to local authentication params [\#165](https://github.com/feathersjs/authentication/issues/165)
- Support custom authentication strategies [\#157](https://github.com/feathersjs/authentication/issues/157)

**Merged pull requests:**

- Allow manipulation of params before checking credentials [\#186](https://github.com/feathersjs/authentication/pull/186) ([saiichihashimoto](https://github.com/saiichihashimoto))
- Update feathers to version 2.0.1 🚀 [\#184](https://github.com/feathersjs/authentication/pull/184) ([greenkeeperio-bot](https://github.com/greenkeeperio-bot))
- fix\(oauth2\): Use patch to update user in oauthCallback [\#183](https://github.com/feathersjs/authentication/pull/183) ([beevelop](https://github.com/beevelop))

## [v0.7.5](https://github.com/feathersjs/authentication/tree/v0.7.5) (2016-04-23)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.7.4...v0.7.5)

**Fixed bugs:**

- restrictToOwner and restrictToRoles have invalid type checking [\#172](https://github.com/feathersjs/authentication/issues/172)

**Closed issues:**

- user fails to signup with facebook if there is also local auth [\#168](https://github.com/feathersjs/authentication/issues/168)
- Unable to authenticate requests when using vanilla Socket.IO [\#166](https://github.com/feathersjs/authentication/issues/166)

## [v0.7.4](https://github.com/feathersjs/authentication/tree/v0.7.4) (2016-04-18)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.7.3...v0.7.4)

**Fixed bugs:**

- restrictToOwner and restrictToRoles hooks don't work with nested models [\#163](https://github.com/feathersjs/authentication/issues/163)
- Change restrictToOwner error when a request does not contain ID [\#160](https://github.com/feathersjs/authentication/issues/160)

**Closed issues:**

- authenticate\(\) can leak sensetive user data via token service [\#162](https://github.com/feathersjs/authentication/issues/162)
- onBeforeLogin Hook [\#161](https://github.com/feathersjs/authentication/issues/161)

**Merged pull requests:**

- Hook fixes [\#164](https://github.com/feathersjs/authentication/pull/164) ([ekryski](https://github.com/ekryski))

## [v0.7.3](https://github.com/feathersjs/authentication/tree/v0.7.3) (2016-04-16)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.7.2...v0.7.3)

## [v0.7.2](https://github.com/feathersjs/authentication/tree/v0.7.2) (2016-04-16)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.7.1...v0.7.2)

**Closed issues:**

- Auth doesn't work with non default local.userEndpoint [\#159](https://github.com/feathersjs/authentication/issues/159)
- Automatically add the hashPassword hook to local.userEndpoint [\#158](https://github.com/feathersjs/authentication/issues/158)
- Client authentication\(\) storage option not documented [\#155](https://github.com/feathersjs/authentication/issues/155)
- restrictToRoles availability inconsistency [\#153](https://github.com/feathersjs/authentication/issues/153)
- Does not populate user for other services [\#150](https://github.com/feathersjs/authentication/issues/150)

**Merged pull requests:**

- Steal Compatibility [\#156](https://github.com/feathersjs/authentication/pull/156) ([marshallswain](https://github.com/marshallswain))

## [v0.7.1](https://github.com/feathersjs/authentication/tree/v0.7.1) (2016-04-08)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.7.0...v0.7.1)

**Closed issues:**

- Documentation discrepancies [\#148](https://github.com/feathersjs/authentication/issues/148)
- bcrypt is hardcoded [\#146](https://github.com/feathersjs/authentication/issues/146)
- Update Docs, Guides, Examples for v0.7 [\#129](https://github.com/feathersjs/authentication/issues/129)
- populateUser: allow option to populate without db call. [\#92](https://github.com/feathersjs/authentication/issues/92)

**Merged pull requests:**

- Update feathers-memory to version 0.7.0 🚀 [\#149](https://github.com/feathersjs/authentication/pull/149) ([greenkeeperio-bot](https://github.com/greenkeeperio-bot))
- fix a typo [\#147](https://github.com/feathersjs/authentication/pull/147) ([chrjean](https://github.com/chrjean))
- Fix copy paste typo in queryWithCurrentUser hook. [\#140](https://github.com/feathersjs/authentication/pull/140) ([juodumas](https://github.com/juodumas))

## [v0.7.0](https://github.com/feathersjs/authentication/tree/v0.7.0) (2016-03-30)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.6.0...v0.7.0)

**Fixed bugs:**

- logout should de-authenticate a socket [\#136](https://github.com/feathersjs/authentication/issues/136)
- \[Security\] JsonWebToken Lifecycle Concerns; Set HttpOnly = true in JWT cookie [\#132](https://github.com/feathersjs/authentication/issues/132)
- restrictToRoles hook needs to throw an error and not scope the query [\#128](https://github.com/feathersjs/authentication/issues/128)
- restrictToOwner hook needs to throw an error and not scope the query [\#127](https://github.com/feathersjs/authentication/issues/127)
- \[security\] Generated tokens are broadcast to all socket clients \(by default\) [\#126](https://github.com/feathersjs/authentication/issues/126)
- \[oAuth\] User profile should be updated every time they are authenticated [\#124](https://github.com/feathersjs/authentication/issues/124)
- Logout should clear the cookie [\#122](https://github.com/feathersjs/authentication/issues/122)
- Want the default success/fail routes, not the sendFile [\#121](https://github.com/feathersjs/authentication/issues/121)

**Closed issues:**

- Make all hooks optional if used internally [\#138](https://github.com/feathersjs/authentication/issues/138)
- Throw errors for deprecated hooks and update documentation [\#134](https://github.com/feathersjs/authentication/issues/134)
- v6.0.0: How can I return the user object along with the token ? [\#131](https://github.com/feathersjs/authentication/issues/131)
- user field not getting populated [\#119](https://github.com/feathersjs/authentication/issues/119)
- Move to bcryptjs [\#112](https://github.com/feathersjs/authentication/issues/112)
- Bundled hooks should pull from auth config to avoid having to pass duplicate props. [\#93](https://github.com/feathersjs/authentication/issues/93)
- Customize the JWT payload [\#78](https://github.com/feathersjs/authentication/issues/78)
- Needs a test for verifying that a custom tokenEndpoint works. [\#59](https://github.com/feathersjs/authentication/issues/59)
- Finish test coverage for existing features. [\#9](https://github.com/feathersjs/authentication/issues/9)

**Merged pull requests:**

- 0.7 Release [\#139](https://github.com/feathersjs/authentication/pull/139) ([ekryski](https://github.com/ekryski))

## [v0.6.0](https://github.com/feathersjs/authentication/tree/v0.6.0) (2016-03-24)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.5.1...v0.6.0)

**Fixed bugs:**

- Token encoding is not using the idField option. [\#107](https://github.com/feathersjs/authentication/issues/107)
- Logging out breaks in React Native [\#105](https://github.com/feathersjs/authentication/issues/105)
- Updating User Attached to Params in Client [\#102](https://github.com/feathersjs/authentication/issues/102)
- local auth should not redirect by default [\#89](https://github.com/feathersjs/authentication/issues/89)

**Closed issues:**

- Id of user can't be 0 for auth [\#116](https://github.com/feathersjs/authentication/issues/116)
- how to authenticate user in the socket.io? [\#111](https://github.com/feathersjs/authentication/issues/111)
- Wrong Status Error [\#110](https://github.com/feathersjs/authentication/issues/110)
- TypeError: Cannot read property 'service' of undefined \(continued\) [\#108](https://github.com/feathersjs/authentication/issues/108)
- `idField` breaks from `tokenService.create\(\)` to `populateUser\(\)` after hook [\#103](https://github.com/feathersjs/authentication/issues/103)

**Merged pull requests:**

- Bcryptjs [\#137](https://github.com/feathersjs/authentication/pull/137) ([ekryski](https://github.com/ekryski))
- Allow user.id to be 0.  Fixes \#116 [\#117](https://github.com/feathersjs/authentication/pull/117) ([marshallswain](https://github.com/marshallswain))
- client should return a 401 error code when no token is provided [\#115](https://github.com/feathersjs/authentication/pull/115) ([ccummings](https://github.com/ccummings))
- v0.6 - Bugs fixes, new hooks, and hook tests [\#109](https://github.com/feathersjs/authentication/pull/109) ([ekryski](https://github.com/ekryski))
- primus client connect event is 'open' [\#106](https://github.com/feathersjs/authentication/pull/106) ([ahdinosaur](https://github.com/ahdinosaur))

## [v0.5.1](https://github.com/feathersjs/authentication/tree/v0.5.1) (2016-03-15)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.5.0...v0.5.1)

## [v0.5.0](https://github.com/feathersjs/authentication/tree/v0.5.0) (2016-03-14)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.4.1...v0.5.0)

**Fixed bugs:**

- Client should store token string and not the token object [\#95](https://github.com/feathersjs/authentication/issues/95)

**Closed issues:**

- using feathers-rest/client with feathers-authentication/client [\#94](https://github.com/feathersjs/authentication/issues/94)
- populateUser can pull defaults from config, if available. [\#91](https://github.com/feathersjs/authentication/issues/91)
- App level auth routes for multiple sub-routes [\#90](https://github.com/feathersjs/authentication/issues/90)
- POST to /auth/local never gets response [\#88](https://github.com/feathersjs/authentication/issues/88)
- populate-user.js do not get settings [\#86](https://github.com/feathersjs/authentication/issues/86)
- Add rate limiting [\#81](https://github.com/feathersjs/authentication/issues/81)

**Merged pull requests:**

- Finalizing client side authentication module [\#101](https://github.com/feathersjs/authentication/pull/101) ([daffl](https://github.com/daffl))
- Ten hours is only 36 seconds [\#99](https://github.com/feathersjs/authentication/pull/99) ([mileswilson](https://github.com/mileswilson))
- Fix examples [\#98](https://github.com/feathersjs/authentication/pull/98) ([mastertinner](https://github.com/mastertinner))
- fix html in templates [\#97](https://github.com/feathersjs/authentication/pull/97) ([mastertinner](https://github.com/mastertinner))
- update populateUser\(\) hook [\#87](https://github.com/feathersjs/authentication/pull/87) ([kulakowka](https://github.com/kulakowka))
- Customize the JWT payload [\#80](https://github.com/feathersjs/authentication/pull/80) ([enten](https://github.com/enten))

## [v0.4.1](https://github.com/feathersjs/authentication/tree/v0.4.1) (2016-02-28)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.4.0...v0.4.1)

**Fixed bugs:**

- app.logout\(\) fails [\#85](https://github.com/feathersjs/authentication/issues/85)

**Closed issues:**

- Username response ? [\#84](https://github.com/feathersjs/authentication/issues/84)
- User doesn't get populated after authentication with databases that don't use \_id  [\#71](https://github.com/feathersjs/authentication/issues/71)
- Support client usage in NodeJS [\#52](https://github.com/feathersjs/authentication/issues/52)
- Support async storage for React Native [\#51](https://github.com/feathersjs/authentication/issues/51)
- RequireAdmin on userService [\#36](https://github.com/feathersjs/authentication/issues/36)
- Create test for changing the `usernameField` [\#1](https://github.com/feathersjs/authentication/issues/1)

## [v0.4.0](https://github.com/feathersjs/authentication/tree/v0.4.0) (2016-02-27)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.3.5...v0.4.0)

**Closed issues:**

- Authentication not worked with hooks.remove\('password'\) [\#82](https://github.com/feathersjs/authentication/issues/82)

**Merged pull requests:**

- Refactoring for storage service [\#76](https://github.com/feathersjs/authentication/pull/76) ([ekryski](https://github.com/ekryski))

## [v0.3.5](https://github.com/feathersjs/authentication/tree/v0.3.5) (2016-02-25)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.3.4...v0.3.5)

**Merged pull requests:**

- Adding support for OAuth2 token based auth strategies. Closes \#46. [\#77](https://github.com/feathersjs/authentication/pull/77) ([ekryski](https://github.com/ekryski))

## [v0.3.4](https://github.com/feathersjs/authentication/tree/v0.3.4) (2016-02-25)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.3.3...v0.3.4)

## [v0.3.3](https://github.com/feathersjs/authentication/tree/v0.3.3) (2016-02-25)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.3.2...v0.3.3)

## [v0.3.2](https://github.com/feathersjs/authentication/tree/v0.3.2) (2016-02-24)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.3.1...v0.3.2)

**Merged pull requests:**

- bumping feathers-errors version [\#79](https://github.com/feathersjs/authentication/pull/79) ([ekryski](https://github.com/ekryski))

## [v0.3.1](https://github.com/feathersjs/authentication/tree/v0.3.1) (2016-02-23)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.3.0...v0.3.1)

**Closed issues:**

- Fix toLowerCase hook [\#74](https://github.com/feathersjs/authentication/issues/74)
- REST auth/local not working if socketio\(\) not set [\#72](https://github.com/feathersjs/authentication/issues/72)
- Support mobile authentication via OAuth2 [\#46](https://github.com/feathersjs/authentication/issues/46)

**Merged pull requests:**

- Fix toLowerCase hook [\#75](https://github.com/feathersjs/authentication/pull/75) ([enten](https://github.com/enten))

## [v0.3.0](https://github.com/feathersjs/authentication/tree/v0.3.0) (2016-02-19)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.2.4...v0.3.0)

**Fixed bugs:**

- Don't register successRedirect route if custom one is passed in [\#61](https://github.com/feathersjs/authentication/issues/61)

**Closed issues:**

- Specify the secret in one place instead of two [\#69](https://github.com/feathersjs/authentication/issues/69)
- support a failRedirect [\#62](https://github.com/feathersjs/authentication/issues/62)
- Document authentication updates [\#50](https://github.com/feathersjs/authentication/issues/50)

**Merged pull requests:**

- Config options [\#70](https://github.com/feathersjs/authentication/pull/70) ([ekryski](https://github.com/ekryski))

## [v0.2.4](https://github.com/feathersjs/authentication/tree/v0.2.4) (2016-02-17)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.2.3...v0.2.4)

**Closed issues:**

- Find "query" is replaced by token [\#64](https://github.com/feathersjs/authentication/issues/64)

**Merged pull requests:**

- Add module exports Babel module and test CommonJS compatibility [\#68](https://github.com/feathersjs/authentication/pull/68) ([daffl](https://github.com/daffl))

## [v0.2.3](https://github.com/feathersjs/authentication/tree/v0.2.3) (2016-02-15)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.2.2...v0.2.3)

**Closed issues:**

- How to forbid get and find on the userEndpoint?   [\#66](https://github.com/feathersjs/authentication/issues/66)
- userEndpoint problem in sub-app [\#63](https://github.com/feathersjs/authentication/issues/63)
- How to modify successRedirect in local authentication? [\#60](https://github.com/feathersjs/authentication/issues/60)

**Merged pull requests:**

- Removing assigning token to params.query for sockets. [\#67](https://github.com/feathersjs/authentication/pull/67) ([ekryski](https://github.com/ekryski))
- Fixing client query [\#65](https://github.com/feathersjs/authentication/pull/65) ([fastlorenzo](https://github.com/fastlorenzo))

## [v0.2.2](https://github.com/feathersjs/authentication/tree/v0.2.2) (2016-02-13)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.2.1...v0.2.2)

**Closed issues:**

- Custom tokenEndpoint failing [\#57](https://github.com/feathersjs/authentication/issues/57)
- TypeError: Cannot read property 'service' of undefined [\#56](https://github.com/feathersjs/authentication/issues/56)
- Login returns 500: Internal server error [\#54](https://github.com/feathersjs/authentication/issues/54)

**Merged pull requests:**

- Fixing token endpoint [\#58](https://github.com/feathersjs/authentication/pull/58) ([marshallswain](https://github.com/marshallswain))

## [v0.2.1](https://github.com/feathersjs/authentication/tree/v0.2.1) (2016-02-12)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.2.0...v0.2.1)

**Closed issues:**

- Custom local options not being respected. [\#55](https://github.com/feathersjs/authentication/issues/55)
- node can not require\("feathers-authentication"\).default [\#53](https://github.com/feathersjs/authentication/issues/53)

## [v0.2.0](https://github.com/feathersjs/authentication/tree/v0.2.0) (2016-02-12)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.1.2...v0.2.0)

**Closed issues:**

- Support graceful fallback to cookies [\#45](https://github.com/feathersjs/authentication/issues/45)
- Add a client side component for authentication [\#44](https://github.com/feathersjs/authentication/issues/44)
- Support OAuth2 [\#43](https://github.com/feathersjs/authentication/issues/43)
- Support token based authentication [\#41](https://github.com/feathersjs/authentication/issues/41)
- Support local authentication [\#40](https://github.com/feathersjs/authentication/issues/40)
- Only sign the JWT with user id. Not the whole user object [\#38](https://github.com/feathersjs/authentication/issues/38)
- Discussion: Securing token for socket.io auth [\#33](https://github.com/feathersjs/authentication/issues/33)
- Handling expired tokens [\#25](https://github.com/feathersjs/authentication/issues/25)
- Support multiple auth providers [\#6](https://github.com/feathersjs/authentication/issues/6)

**Merged pull requests:**

- Decoupling [\#49](https://github.com/feathersjs/authentication/pull/49) ([ekryski](https://github.com/ekryski))
- Adding an auth client [\#48](https://github.com/feathersjs/authentication/pull/48) ([ekryski](https://github.com/ekryski))
- Validate if provider [\#39](https://github.com/feathersjs/authentication/pull/39) ([mastertinner](https://github.com/mastertinner))

## [v0.1.2](https://github.com/feathersjs/authentication/tree/v0.1.2) (2016-02-04)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.1.1...v0.1.2)

**Closed issues:**

- Hooks should support incoming data as arrays of objects. [\#34](https://github.com/feathersjs/authentication/issues/34)
- Support authenticating with Username and Password via sockets [\#32](https://github.com/feathersjs/authentication/issues/32)

**Merged pull requests:**

- Check for params.provider in requireAuth hook [\#37](https://github.com/feathersjs/authentication/pull/37) ([marshallswain](https://github.com/marshallswain))
- safety check for data [\#35](https://github.com/feathersjs/authentication/pull/35) ([deanmcpherson](https://github.com/deanmcpherson))

## [v0.1.1](https://github.com/feathersjs/authentication/tree/v0.1.1) (2016-01-30)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.1.0...v0.1.1)

## [v0.1.0](https://github.com/feathersjs/authentication/tree/v0.1.0) (2016-01-25)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.0.8...v0.1.0)

**Closed issues:**

- Get the Travis build to work. [\#27](https://github.com/feathersjs/authentication/issues/27)
- Login not working [\#24](https://github.com/feathersjs/authentication/issues/24)
- Hooks should be configurable \(they should be functions\) [\#11](https://github.com/feathersjs/authentication/issues/11)
- Document the bundled hooks. [\#10](https://github.com/feathersjs/authentication/issues/10)

**Merged pull requests:**

- Migrate docs to book [\#31](https://github.com/feathersjs/authentication/pull/31) ([marshallswain](https://github.com/marshallswain))
- hashPassword: Async bcrypt usage needs a promise [\#30](https://github.com/feathersjs/authentication/pull/30) ([marshallswain](https://github.com/marshallswain))
- Removing extras from travis.yml [\#29](https://github.com/feathersjs/authentication/pull/29) ([marshallswain](https://github.com/marshallswain))
- Fixing build [\#28](https://github.com/feathersjs/authentication/pull/28) ([marshallswain](https://github.com/marshallswain))
- Adding nsp check [\#26](https://github.com/feathersjs/authentication/pull/26) ([marshallswain](https://github.com/marshallswain))

## [v0.0.8](https://github.com/feathersjs/authentication/tree/v0.0.8) (2016-01-16)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.0.7...v0.0.8)

**Merged pull requests:**

- Support services that use pagination. [\#23](https://github.com/feathersjs/authentication/pull/23) ([marshallswain](https://github.com/marshallswain))

## [v0.0.7](https://github.com/feathersjs/authentication/tree/v0.0.7) (2016-01-07)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.0.6...v0.0.7)

**Closed issues:**

- Password isn't removed from responses when using a mongoose service for users endpoint  [\#19](https://github.com/feathersjs/authentication/issues/19)
- next called twice using socket.io and using an unauthenticated service [\#17](https://github.com/feathersjs/authentication/issues/17)
- Switch to a callback-based field configuration? [\#15](https://github.com/feathersjs/authentication/issues/15)
- Cannot authenticate [\#14](https://github.com/feathersjs/authentication/issues/14)
- Allow require without `.default` [\#13](https://github.com/feathersjs/authentication/issues/13)
- Login validation [\#2](https://github.com/feathersjs/authentication/issues/2)

**Merged pull requests:**

- Adding separate route for refreshing a login token.  [\#21](https://github.com/feathersjs/authentication/pull/21) ([corymsmith](https://github.com/corymsmith))
- Converting user model to object when using mongoose service [\#20](https://github.com/feathersjs/authentication/pull/20) ([corymsmith](https://github.com/corymsmith))
- Fixing issue where next is called twice when hitting an unauthenticated service via socket.io [\#18](https://github.com/feathersjs/authentication/pull/18) ([corymsmith](https://github.com/corymsmith))
- Fixing usage of mongoose service [\#16](https://github.com/feathersjs/authentication/pull/16) ([corymsmith](https://github.com/corymsmith))

## [v0.0.6](https://github.com/feathersjs/authentication/tree/v0.0.6) (2015-11-22)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.0.5...v0.0.6)

**Closed issues:**

- Feathers Auth Configuration Error [\#12](https://github.com/feathersjs/authentication/issues/12)
- Make sure we're returning proper error responses. [\#8](https://github.com/feathersjs/authentication/issues/8)

## [v0.0.5](https://github.com/feathersjs/authentication/tree/v0.0.5) (2015-11-19)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.0.4...v0.0.5)

## [v0.0.4](https://github.com/feathersjs/authentication/tree/v0.0.4) (2015-11-19)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v0.0.3...v0.0.4)

## [v0.0.3](https://github.com/feathersjs/authentication/tree/v0.0.3) (2015-11-18)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.0.6...v0.0.3)

**Merged pull requests:**

- allow runtime auth via socket.io [\#4](https://github.com/feathersjs/authentication/pull/4) ([randomnerd](https://github.com/randomnerd))

## [v1.0.6](https://github.com/feathersjs/authentication/tree/v1.0.6) (2015-11-02)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.0.5...v1.0.6)

## [v1.0.5](https://github.com/feathersjs/authentication/tree/v1.0.5) (2015-11-02)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.0.4...v1.0.5)

## [v1.0.4](https://github.com/feathersjs/authentication/tree/v1.0.4) (2015-11-02)
[Full Changelog](https://github.com/feathersjs/authentication/compare/v1.0.3...v1.0.4)

## [v1.0.3](https://github.com/feathersjs/authentication/tree/v1.0.3) (2015-10-12)


\* *This Change Log was automatically generated by [github_changelog_generator](https://github.com/skywinder/Github-Changelog-Generator)*
