"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const flatten_1 = __importDefault(require("lodash/flatten"));
const omit_1 = __importDefault(require("lodash/omit"));
const errors_1 = require("@feathersjs/errors");
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@feathersjs/authentication/hooks/authenticate');
exports.default = (originalSettings, ...originalStrategies) => {
    const settings = typeof originalSettings === 'string'
        ? { strategies: (0, flatten_1.default)([originalSettings, ...originalStrategies]) }
        : originalSettings;
    if (!originalSettings || settings.strategies.length === 0) {
        throw new Error('The authenticate hook needs at least one allowed strategy');
    }
    return (context) => __awaiter(void 0, void 0, void 0, function* () {
        const { app, params, type, path, service } = context;
        const { strategies } = settings;
        const { provider, authentication } = params;
        const authService = app.defaultAuthentication(settings.service);
        debug(`Running authenticate hook on '${path}'`);
        if (type && type !== 'before') {
            throw new errors_1.NotAuthenticated('The authenticate hook must be used as a before hook');
        }
        if (!authService || typeof authService.authenticate !== 'function') {
            throw new errors_1.NotAuthenticated('Could not find a valid authentication service');
        }
        // @ts-ignore
        if (service === authService) {
            throw new errors_1.NotAuthenticated('The authenticate hook does not need to be used on the authentication service');
        }
        if (params.authenticated === true) {
            return context;
        }
        if (authentication) {
            const authParams = (0, omit_1.default)(params, 'provider', 'authentication');
            debug('Authenticating with', authentication, strategies);
            const authResult = yield authService.authenticate(authentication, authParams, ...strategies);
            context.params = Object.assign({}, params, (0, omit_1.default)(authResult, 'accessToken'), { authenticated: true });
            return context;
        }
        else if (provider) {
            throw new errors_1.NotAuthenticated('Not authenticated');
        }
        return context;
    });
};
//# sourceMappingURL=authenticate.js.map