import { Channel, RealTimeConnection } from './channel/base';
import { keys, Event, Publisher } from './mixins';
import { Application } from '@feathersjs/feathers';
declare module '@feathersjs/feathers' {
    interface ServiceAddons<T> {
        publish(publisher: Publisher<T>): this;
        publish(event: Event, publisher: Publisher<T>): this;
        registerPublisher(publisher: Publisher<T>): this;
        registerPublisher(event: Event, publisher: Publisher<T>): this;
    }
    interface Application<ServiceTypes> {
        channels: string[];
        channel(name: string[]): Channel;
        channel(...names: string[]): Channel;
        publish<T>(publisher: Publisher<T>): this;
        publish<T>(event: Event, publisher: Publisher<T>): this;
        registerPublisher<T>(publisher: Publisher<T>): this;
        registerPublisher<T>(event: Event, publisher: Publisher<T>): this;
    }
    interface Params {
        connection?: RealTimeConnection;
    }
}
export { keys };
export declare function channels(): (app: Application) => void;
