"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
const path_1 = __importDefault(require("path"));
const config_1 = __importDefault(require("config"));
const debug = (0, debug_1.default)('@feathersjs/configuration');
const separator = path_1.default.sep;
function init() {
    return (app) => {
        const convert = (current) => {
            const result = Array.isArray(current) ? [] : {};
            Object.keys(current).forEach(name => {
                let value = current[name];
                if (typeof value === 'object' && value !== null) {
                    value = convert(value);
                }
                if (typeof value === 'string') {
                    if (value.indexOf('\\') === 0) {
                        value = value.replace('\\', '');
                    }
                    else {
                        if (process.env[value]) {
                            value = process.env[value];
                        }
                        if (value.indexOf('./') === 0 || value.indexOf('../') === 0) {
                            // Make relative paths absolute
                            value = path_1.default.resolve(path_1.default.join(config_1.default.util.getEnv('NODE_CONFIG_DIR')), value.replace(/\//g, separator));
                        }
                    }
                }
                result[name] = value;
            });
            return result;
        };
        const env = config_1.default.util.getEnv('NODE_ENV');
        const conf = convert(config_1.default);
        if (!app) {
            return conf;
        }
        debug(`Initializing configuration for ${env} environment`);
        Object.keys(conf).forEach(name => {
            const value = conf[name];
            debug(`Setting ${name} configuration value to`, value);
            app.set(name, value);
        });
        return conf;
    };
}
exports.default = init;
if (typeof module !== 'undefined') {
    module.exports = Object.assign(init, module.exports);
}
//# sourceMappingURL=index.js.map