import { AsyncMiddleware } from './compose.js';
export declare const HOOKS: string;
export type HookContextData = {
    [key: string]: any;
};
/**
 * The base hook context.
 */
export declare class BaseHookContext<C = any> {
    self?: C;
    [key: string]: any;
    constructor(data?: HookContextData);
    toJSON(): this;
}
export interface HookContext<T = any, C = any> extends BaseHookContext<C> {
    result?: T;
    method?: string;
    arguments: any[];
}
export type HookContextConstructor = new (data?: {
    [key: string]: any;
}) => BaseHookContext;
export type HookDefaultsInitializer = (self?: any, args?: any[], context?: HookContext) => HookContextData;
export declare class HookManager {
    _parent?: this | null;
    _params: string[] | null;
    _middleware: AsyncMiddleware[] | null;
    _props: HookContextData | null;
    _defaults?: HookDefaultsInitializer;
    parent(parent: this | null): this;
    middleware(middleware?: AsyncMiddleware[]): this;
    getMiddleware(): AsyncMiddleware[] | null;
    collectMiddleware(self: any, _args: any[]): AsyncMiddleware[];
    props(props: HookContextData): this;
    getProps(): HookContextData | null;
    params(...params: string[]): this;
    getParams(): string[] | null;
    defaults(defaults: HookDefaultsInitializer): this;
    getDefaults(self: any, args: any[], context: HookContext): HookContextData | null;
    getContextClass(Base?: HookContextConstructor): HookContextConstructor;
    initializeContext(self: any, args: any[], context: HookContext): HookContext;
}
export type HookOptions = HookManager | AsyncMiddleware[] | null;
export declare function convertOptions(options?: HookOptions): HookManager;
export declare function getManager(target: any): HookManager | null;
export declare function setManager<T>(target: T, manager: HookManager): T;
export declare function getMiddleware(target: any): AsyncMiddleware[] | null;
export declare function setMiddleware<T>(target: T, middleware: AsyncMiddleware[]): T;
