"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.socket = void 0;
const debug_1 = __importDefault(require("debug"));
const channels_1 = require("../channels");
const routing_1 = require("../routing");
const utils_1 = require("./utils");
const debug = (0, debug_1.default)('@feathersjs/transport-commons');
function socket({ done, emit, socketMap, socketKey, getParams }) {
    return (app) => {
        const leaveChannels = (connection) => {
            const { channels } = app;
            if (channels.length) {
                app.channel(app.channels).leave(connection);
            }
        };
        app.configure((0, channels_1.channels)());
        app.configure((0, routing_1.routing)());
        app.on('publish', (0, utils_1.getDispatcher)(emit, socketMap, socketKey));
        app.on('disconnect', leaveChannels);
        app.on('logout', (_authResult, params) => {
            const { connection } = params;
            if (connection) {
                leaveChannels(connection);
            }
        });
        // `connection` event
        done.then((provider) => provider.on('connection', (connection) => app.emit('connection', getParams(connection))));
        // `socket.emit('methodName', 'serviceName', ...args)` handlers
        done.then((provider) => provider.on('connection', (connection) => {
            for (const method of app.methods) {
                connection.on(method, (...args) => {
                    const [path, ...rest] = args;
                    (0, utils_1.runMethod)(app, getParams(connection), path, method, rest);
                });
            }
            connection.on('authenticate', (...args) => {
                if (app.get('defaultAuthentication')) {
                    debug('Got legacy authenticate event');
                    (0, utils_1.runMethod)(app, getParams(connection), app.get('defaultAuthentication'), 'create', args);
                }
            });
            connection.on('logout', (callback) => {
                if (app.get('defaultAuthentication')) {
                    debug('Got legacy authenticate event');
                    (0, utils_1.runMethod)(app, getParams(connection), app.get('defaultAuthentication'), 'remove', [null, {}, callback]);
                }
            });
        }));
        // Legacy `socket.emit('serviceName::methodName', ...args)` handlers
        app.mixins.push((service, path) => done.then((provider) => {
            provider.on('connection', (socket) => {
                const methods = app.methods.filter((current) => 
                // @ts-ignore
                typeof service[current] === 'function');
                for (const method of methods) {
                    const eventName = `${path}::${method}`;
                    socket.on(eventName, (...args) => {
                        debug(`Got legacy method call '${eventName}'`);
                        (0, utils_1.runMethod)(app, getParams(socket), path, method, args);
                    });
                }
            });
        }));
    };
}
exports.socket = socket;
//# sourceMappingURL=index.js.map