# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## [5.0.34](https://github.com/feathersjs/feathers/compare/v5.0.33...v5.0.34) (2025-05-03)

### Bug Fixes

- Update dependencies ([#3584](https://github.com/feathersjs/feathers/issues/3584)) ([119fa4e](https://github.com/feathersjs/feathers/commit/119fa4e1ade8b0078aa235083d566e2538b3a084))

## [5.0.33](https://github.com/feathersjs/feathers/compare/v5.0.32...v5.0.33) (2025-02-24)

### Bug Fixes

- **dependencies:** Update dependencies ([#3571](https://github.com/feathersjs/feathers/issues/3571)) ([ad611cb](https://github.com/feathersjs/feathers/commit/ad611cb6ffb1dc31d603ba5817331318c5a23217))

## [5.0.32](https://github.com/feathersjs/feathers/compare/v5.0.31...v5.0.32) (2025-02-01)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.31](https://github.com/feathersjs/feathers/compare/v5.0.30...v5.0.31) (2024-10-31)

### Bug Fixes

- **dependencies:** Update all dependencies ([#3545](https://github.com/feathersjs/feathers/issues/3545)) ([221b92b](https://github.com/feathersjs/feathers/commit/221b92bb0ee5d54fb1036742968797cb02e56da2))

## [5.0.30](https://github.com/feathersjs/feathers/compare/v5.0.29...v5.0.30) (2024-09-02)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.29](https://github.com/feathersjs/feathers/compare/v5.0.28...v5.0.29) (2024-07-10)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.28](https://github.com/feathersjs/feathers/compare/v5.0.27...v5.0.28) (2024-07-10)

### Bug Fixes

- **transport-commons:** Fix HTTP status precedence ([#3511](https://github.com/feathersjs/feathers/issues/3511)) ([5d999a0](https://github.com/feathersjs/feathers/commit/5d999a0acddc0cb7692058209dfbc62673ab5a69))

## [5.0.27](https://github.com/feathersjs/feathers/compare/v5.0.26...v5.0.27) (2024-06-18)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.26](https://github.com/feathersjs/feathers/compare/v5.0.25...v5.0.26) (2024-06-09)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.25](https://github.com/feathersjs/feathers/compare/v5.0.24...v5.0.25) (2024-05-03)

### Bug Fixes

- Reduce usage of lodash ([#3455](https://github.com/feathersjs/feathers/issues/3455)) ([8ce807a](https://github.com/feathersjs/feathers/commit/8ce807a5ca53ff5b8d5107a0656c6329404e6e6c))

## [5.0.24](https://github.com/feathersjs/feathers/compare/v5.0.23...v5.0.24) (2024-03-13)

### Bug Fixes

- **socketio:** Handle ackTimeout of socket.io ([#3437](https://github.com/feathersjs/feathers/issues/3437)) ([2642072](https://github.com/feathersjs/feathers/commit/26420721f3eb16f716a9e68ab3ed9f415bab7a9c))

## [5.0.23](https://github.com/feathersjs/feathers/compare/v5.0.22...v5.0.23) (2024-02-25)

### Bug Fixes

- **core:** Update to latest feathersjs/hooks ([#3434](https://github.com/feathersjs/feathers/issues/3434)) ([1499ccc](https://github.com/feathersjs/feathers/commit/1499ccc41fb3ebba97b2c84e0cb19bc48ad3c651))
- **transport-commons:** Properly delete route data ([#3433](https://github.com/feathersjs/feathers/issues/3433)) ([af01bdb](https://github.com/feathersjs/feathers/commit/af01bdbe050dd428d6fffefa1874e9a6e4182bad))

## [5.0.22](https://github.com/feathersjs/feathers/compare/v5.0.21...v5.0.22) (2024-02-15)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.21](https://github.com/feathersjs/feathers/compare/v5.0.20...v5.0.21) (2024-01-25)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.20](https://github.com/feathersjs/feathers/compare/v5.0.19...v5.0.20) (2024-01-24)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.19](https://github.com/feathersjs/feathers/compare/v5.0.18...v5.0.19) (2024-01-23)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.18](https://github.com/feathersjs/feathers/compare/v5.0.17...v5.0.18) (2024-01-22)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.17](https://github.com/feathersjs/feathers/compare/v5.0.16...v5.0.17) (2024-01-22)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.16](https://github.com/feathersjs/feathers/compare/v5.0.15...v5.0.16) (2024-01-22)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.15](https://github.com/feathersjs/feathers/compare/v5.0.14...v5.0.15) (2024-01-22)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.14](https://github.com/feathersjs/feathers/compare/v5.0.13...v5.0.14) (2024-01-05)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.13](https://github.com/feathersjs/feathers/compare/v5.0.12...v5.0.13) (2023-12-29)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.12](https://github.com/feathersjs/feathers/compare/v5.0.11...v5.0.12) (2023-11-28)

### Bug Fixes

- **transport-commons:** Allow case insensitive route lookups ([#3353](https://github.com/feathersjs/feathers/issues/3353)) ([a4a5ab6](https://github.com/feathersjs/feathers/commit/a4a5ab6cb59048176292cd71c04a32aa71ac4642))

## [5.0.11](https://github.com/feathersjs/feathers/compare/v5.0.10...v5.0.11) (2023-10-11)

### Bug Fixes

- **client:** Replace placeholders in URL with route params ([#3270](https://github.com/feathersjs/feathers/issues/3270)) ([a0624eb](https://github.com/feathersjs/feathers/commit/a0624eb5a7919aa1b179a71beb1c1b9cab574525))
- **knex:** Update all dependencies and Knex peer ([#3308](https://github.com/feathersjs/feathers/issues/3308)) ([d2f9860](https://github.com/feathersjs/feathers/commit/d2f986036c4741cce2339d8abbcc6b2eb037a12a))

## [5.0.10](https://github.com/feathersjs/feathers/compare/v5.0.9...v5.0.10) (2023-10-03)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.9](https://github.com/feathersjs/feathers/compare/v5.0.8...v5.0.9) (2023-09-27)

### Bug Fixes

- **client:** Add underscored methods to clients ([#3176](https://github.com/feathersjs/feathers/issues/3176)) ([f3c01f7](https://github.com/feathersjs/feathers/commit/f3c01f7b8266bfc642c55b77ba8e5bb333542630))

## [5.0.8](https://github.com/feathersjs/feathers/compare/v5.0.7...v5.0.8) (2023-07-19)

### Bug Fixes

- **transport-commons:** Handle invalid service paths on socket lookups ([#3241](https://github.com/feathersjs/feathers/issues/3241)) ([c397ab3](https://github.com/feathersjs/feathers/commit/c397ab3a0cd184044ae4f73540549b30a396821c))

## [5.0.7](https://github.com/feathersjs/feathers/compare/v5.0.6...v5.0.7) (2023-07-14)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.6](https://github.com/feathersjs/feathers/compare/v5.0.5...v5.0.6) (2023-06-15)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.5](https://github.com/feathersjs/feathers/compare/v5.0.4...v5.0.5) (2023-04-28)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.4](https://github.com/feathersjs/feathers/compare/v5.0.3...v5.0.4) (2023-04-12)

**Note:** Version bump only for package @feathersjs/transport-commons

## [5.0.3](https://github.com/feathersjs/feathers/compare/v5.0.2...v5.0.3) (2023-04-05)

### Bug Fixes

- **dependencies:** Update all dependencies ([#3139](https://github.com/feathersjs/feathers/issues/3139)) ([f24276e](https://github.com/feathersjs/feathers/commit/f24276e9a909e2e58a0730c730258ce1f70f4028))

## [5.0.1](https://github.com/feathersjs/feathers/compare/v5.0.0...v5.0.1) (2023-03-15)

### Bug Fixes

- **core:** Use Symbol.for to instantiate shared symbols ([#3087](https://github.com/feathersjs/feathers/issues/3087)) ([7f3fc21](https://github.com/feathersjs/feathers/commit/7f3fc2167576f228f8183568eb52b077160e8d65))
- **transport-commons:** Fix dispatching of arrays ([#3075](https://github.com/feathersjs/feathers/issues/3075)) ([98fdda5](https://github.com/feathersjs/feathers/commit/98fdda53187acee88137b39662c766cc62cd7b55))

# [5.0.0](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.38...v5.0.0) (2023-02-24)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.38](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.37...v5.0.0-pre.38) (2023-02-17)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.37](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.36...v5.0.0-pre.37) (2023-02-09)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.36](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.35...v5.0.0-pre.36) (2023-01-29)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.35](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.34...v5.0.0-pre.35) (2023-01-12)

### Features

- **generators:** Move core code generators to shared generators package ([#2982](https://github.com/feathersjs/feathers/issues/2982)) ([0328d22](https://github.com/feathersjs/feathers/commit/0328d2292153870bc43958f73d2c6f288a8cec17))

# [5.0.0-pre.34](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.33...v5.0.0-pre.34) (2022-12-14)

### Bug Fixes

- **core:** Improve service option usage and method option typings ([#2902](https://github.com/feathersjs/feathers/issues/2902)) ([164d75c](https://github.com/feathersjs/feathers/commit/164d75c0f11139a316baa91f1762de8f8eb7da2d))

# [5.0.0-pre.33](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.32...v5.0.0-pre.33) (2022-11-08)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.32](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.31...v5.0.0-pre.32) (2022-10-26)

### Bug Fixes

- **docs:** Review transport API docs and update Express middleware setup ([#2811](https://github.com/feathersjs/feathers/issues/2811)) ([1b97f14](https://github.com/feathersjs/feathers/commit/1b97f14d474f5613482f259eeaa585c24fcfab43))

# [5.0.0-pre.31](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.30...v5.0.0-pre.31) (2022-10-12)

### Features

- **cli:** Generate full client test suite and improve typed client ([#2788](https://github.com/feathersjs/feathers/issues/2788)) ([57119b6](https://github.com/feathersjs/feathers/commit/57119b6bb2797f7297cf054268a248c093ecd538))

# [5.0.0-pre.30](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.29...v5.0.0-pre.30) (2022-10-07)

### Features

- **core:** Allow to unregister services at runtime ([#2756](https://github.com/feathersjs/feathers/issues/2756)) ([d16601f](https://github.com/feathersjs/feathers/commit/d16601f2277dca5357866ffdefba2a611f6dc7fa))

# [5.0.0-pre.29](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.28...v5.0.0-pre.29) (2022-09-16)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.28](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.27...v5.0.0-pre.28) (2022-08-03)

### Bug Fixes

- **cli:** Improve generated application and client ([#2701](https://github.com/feathersjs/feathers/issues/2701)) ([bd55ffb](https://github.com/feathersjs/feathers/commit/bd55ffb812e89bf215f4515e7f137656ea888c3f))

# [5.0.0-pre.27](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.26...v5.0.0-pre.27) (2022-07-13)

### Bug Fixes

- **socketio-client:** Make Socket.io client event target compatible ([#2686](https://github.com/feathersjs/feathers/issues/2686)) ([716c49a](https://github.com/feathersjs/feathers/commit/716c49a270e4be5e5276192092c292f72ffcfa19))

# [5.0.0-pre.26](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.25...v5.0.0-pre.26) (2022-06-22)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.25](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.24...v5.0.0-pre.25) (2022-06-22)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.24](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.23...v5.0.0-pre.24) (2022-06-21)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.23](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.22...v5.0.0-pre.23) (2022-06-06)

### Features

- **client:** Improve client side custom method support ([#2654](https://github.com/feathersjs/feathers/issues/2654)) ([c138acf](https://github.com/feathersjs/feathers/commit/c138acf50affbe6b66177d084d3c7a3e9220f09f))

# [5.0.0-pre.22](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.21...v5.0.0-pre.22) (2022-05-24)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.21](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.20...v5.0.0-pre.21) (2022-05-23)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.20](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.19...v5.0.0-pre.20) (2022-05-04)

### Bug Fixes

- **dependencies:** Lock monorepo package version numbers ([#2623](https://github.com/feathersjs/feathers/issues/2623)) ([5640c10](https://github.com/feathersjs/feathers/commit/5640c1020cc139994e695d658c08bad3494db507))

# [5.0.0-pre.19](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.18...v5.0.0-pre.19) (2022-05-01)

### Bug Fixes

- **transport-commons:** Ensure socket queries are always plain objects ([#2597](https://github.com/feathersjs/feathers/issues/2597)) ([97313e1](https://github.com/feathersjs/feathers/commit/97313e121cfee4199f10012e95b8507557aa507e))

# [5.0.0-pre.18](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.17...v5.0.0-pre.18) (2022-04-11)

### Features

- **transport-commons:** add `context.http.response` ([#2524](https://github.com/feathersjs/feathers/issues/2524)) ([5bc9d44](https://github.com/feathersjs/feathers/commit/5bc9d447043c2e2b742c73ed28ecf3b3264dd9e5))

# [5.0.0-pre.17](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.16...v5.0.0-pre.17) (2022-02-15)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.16](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.15...v5.0.0-pre.16) (2022-01-12)

### Features

- **express, koa:** make transports similar ([#2486](https://github.com/feathersjs/feathers/issues/2486)) ([26aa937](https://github.com/feathersjs/feathers/commit/26aa937c114fb8596dfefc599b1f53cead69c159))

# [5.0.0-pre.15](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.14...v5.0.0-pre.15) (2021-11-27)

### Bug Fixes

- **typescript:** Overall typing improvements ([#2478](https://github.com/feathersjs/feathers/issues/2478)) ([b8eb804](https://github.com/feathersjs/feathers/commit/b8eb804158556d9651a8607e3c3fda15e0bfd110))

### Features

- **core:** add `context.http` and move `statusCode` there ([#2496](https://github.com/feathersjs/feathers/issues/2496)) ([b701bf7](https://github.com/feathersjs/feathers/commit/b701bf77fb83048aa1dffa492b3d77dd53f7b72b))
- **transport-commons:** Ability to register routes with custom params ([#2482](https://github.com/feathersjs/feathers/issues/2482)) ([497990a](https://github.com/feathersjs/feathers/commit/497990ae4a980e5a52a1f0f932db12cd0e6e254a))

# [5.0.0-pre.14](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.13...v5.0.0-pre.14) (2021-10-13)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.13](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.12...v5.0.0-pre.13) (2021-10-13)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.12](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.11...v5.0.0-pre.12) (2021-10-12)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.11](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.10...v5.0.0-pre.11) (2021-10-06)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.10](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.9...v5.0.0-pre.10) (2021-09-19)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.9](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.8...v5.0.0-pre.9) (2021-08-09)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.8](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.7...v5.0.0-pre.8) (2021-08-09)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.7](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.6...v5.0.0-pre.7) (2021-08-09)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.6](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.5...v5.0.0-pre.6) (2021-08-08)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-pre.5](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.4...v5.0.0-pre.5) (2021-06-23)

### Bug Fixes

- **koa:** Use extended query parser for compatibility ([#2397](https://github.com/feathersjs/feathers/issues/2397)) ([b2944ba](https://github.com/feathersjs/feathers/commit/b2944bac3ec6d5ecc80dc518cd4e58093692db74))

# [5.0.0-pre.4](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.3...v5.0.0-pre.4) (2021-05-13)

### Bug Fixes

- **transport-commons:** Fix route placeholder registration and improve radix router performance ([#2336](https://github.com/feathersjs/feathers/issues/2336)) ([4d84dfd](https://github.com/feathersjs/feathers/commit/4d84dfd092ce0510312e975d5cd57e04973fb311))

### Features

- **koa:** KoaJS transport adapter ([#2315](https://github.com/feathersjs/feathers/issues/2315)) ([2554b57](https://github.com/feathersjs/feathers/commit/2554b57cf05731df58feeba9c12faab18e442107))

# [5.0.0-pre.3](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.2...v5.0.0-pre.3) (2021-04-21)

### Bug Fixes

- **typescript:** Improve TypeScript backwards compatibility ([#2310](https://github.com/feathersjs/feathers/issues/2310)) ([f33be73](https://github.com/feathersjs/feathers/commit/f33be73fc46a533efb15df9aab0658e3240d3897))

### Features

- **dependencies:** Remove direct debug dependency ([#2296](https://github.com/feathersjs/feathers/issues/2296)) ([501d416](https://github.com/feathersjs/feathers/commit/501d4164d30c6a126906dc640cdfdc82207ba34a))

# [5.0.0-pre.2](https://github.com/feathersjs/feathers/compare/v5.0.0-beta.1...v5.0.0-pre.2) (2021-04-06)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-beta.1](https://github.com/feathersjs/feathers/compare/v5.0.0-beta.0...v5.0.0-beta.1) (2021-04-03)

**Note:** Version bump only for package @feathersjs/transport-commons

# [5.0.0-beta.0](https://github.com/feathersjs/feathers/compare/v5.0.0-pre.1...v5.0.0-beta.0) (2021-03-28)

### Bug Fixes

- **transport-commons:** Do not error when adding an undefined connection to a channel ([#2268](https://github.com/feathersjs/feathers/issues/2268)) ([28114c4](https://github.com/feathersjs/feathers/commit/28114c495d6564868bb3ffbf619bf80b774dce4b))
- Update Grant usage and other dependencies ([#2264](https://github.com/feathersjs/feathers/issues/2264)) ([7b0f8fa](https://github.com/feathersjs/feathers/commit/7b0f8fad252419ed0ad0bf259cdf3104d322ab60))
- **socketio-client:** Fix client transport-commons reference ([#2164](https://github.com/feathersjs/feathers/issues/2164)) ([3a42c54](https://github.com/feathersjs/feathers/commit/3a42c544058456b19c7e21827226541bfa6ad621))

### Features

- **core:** Public custom service methods ([#2270](https://github.com/feathersjs/feathers/issues/2270)) ([e65abfb](https://github.com/feathersjs/feathers/commit/e65abfb5388df6c19a11c565cf1076a29f32668d))
- Application service types default to any ([#1566](https://github.com/feathersjs/feathers/issues/1566)) ([d93ba9a](https://github.com/feathersjs/feathers/commit/d93ba9a17edd20d3397bb00f4f6e82e804e42ed6))
- Feathers v5 core refactoring and features ([#2255](https://github.com/feathersjs/feathers/issues/2255)) ([2dafb7c](https://github.com/feathersjs/feathers/commit/2dafb7ce14ba57406aeec13d10ca45b1e709bee9))
- **transport-commons:** New built-in high performance radix router ([#2177](https://github.com/feathersjs/feathers/issues/2177)) ([6d18065](https://github.com/feathersjs/feathers/commit/6d180651b4eb40289ecea3df3575f207aa6c5d1f))

# [5.0.0-pre.1](https://github.com/feathersjs/feathers/compare/v4.5.11...v5.0.0-pre.1) (2020-12-17)

# [5.0.0-pre.0](https://github.com/feathersjs/feathers/compare/v4.5.4...v5.0.0-pre.0) (2020-05-19)

### Features

- **core:** use @feathers/hooks and add async type ([#1929](https://github.com/feathersjs/feathers/issues/1929)) ([a5c4756](https://github.com/feathersjs/feathers/commit/a5c47562eae8410c82fe2f6308f26f8e78b6a3e8))
- **transport-commons:** Remove legacy message format and unnecessary client timeouts ([#1939](https://github.com/feathersjs/feathers/issues/1939)) ([5538881](https://github.com/feathersjs/feathers/commit/5538881a08bc130de42c5984055729d8336f8615))

### BREAKING CHANGES

- **transport-commons:** Removes the old message format and client service timeout

# [5.0.0-pre.0](https://github.com/feathersjs/feathers/compare/v4.5.4...v5.0.0-pre.0) (2020-05-19)

### Features

- **core:** use @feathers/hooks and add async type ([#1929](https://github.com/feathersjs/feathers/issues/1929)) ([a5c4756](https://github.com/feathersjs/feathers/commit/a5c47562eae8410c82fe2f6308f26f8e78b6a3e8))
- **transport-commons:** Remove legacy message format and unnecessary client timeouts ([#1939](https://github.com/feathersjs/feathers/issues/1939)) ([5538881](https://github.com/feathersjs/feathers/commit/5538881a08bc130de42c5984055729d8336f8615))

### BREAKING CHANGES

- **transport-commons:** Removes the old message format and client service timeout

## [4.5.11](https://github.com/feathersjs/feathers/compare/v4.5.10...v4.5.11) (2020-12-05)

### Bug Fixes

- **socketio-client:** Throw an error and show a warning if someone tries to use socket.io-client v3 ([#2135](https://github.com/feathersjs/feathers/issues/2135)) ([cc3521c](https://github.com/feathersjs/feathers/commit/cc3521c935a1cbd690e29b7057998e3898f282db))

## [4.5.10](https://github.com/feathersjs/feathers/compare/v4.5.9...v4.5.10) (2020-11-08)

**Note:** Version bump only for package @feathersjs/transport-commons

## [4.5.9](https://github.com/feathersjs/feathers/compare/v4.5.8...v4.5.9) (2020-10-09)

**Note:** Version bump only for package @feathersjs/transport-commons

## [4.5.8](https://github.com/feathersjs/feathers/compare/v4.5.7...v4.5.8) (2020-08-12)

**Note:** Version bump only for package @feathersjs/transport-commons

## [4.5.7](https://github.com/feathersjs/feathers/compare/v4.5.6...v4.5.7) (2020-07-24)

**Note:** Version bump only for package @feathersjs/transport-commons

## [4.5.5](https://github.com/feathersjs/feathers/compare/v4.5.4...v4.5.5) (2020-07-11)

**Note:** Version bump only for package @feathersjs/transport-commons

## [4.5.3](https://github.com/feathersjs/feathers/compare/v4.5.2...v4.5.3) (2020-04-17)

**Note:** Version bump only for package @feathersjs/transport-commons

## [4.5.2](https://github.com/feathersjs/feathers/compare/v4.5.1...v4.5.2) (2020-03-04)

**Note:** Version bump only for package @feathersjs/transport-commons

## [4.5.1](https://github.com/feathersjs/feathers/compare/v4.5.0...v4.5.1) (2020-01-24)

**Note:** Version bump only for package @feathersjs/transport-commons

# [4.5.0](https://github.com/feathersjs/feathers/compare/v4.4.3...v4.5.0) (2020-01-18)

**Note:** Version bump only for package @feathersjs/transport-commons

## [4.4.3](https://github.com/feathersjs/feathers/compare/v4.4.1...v4.4.3) (2019-12-06)

**Note:** Version bump only for package @feathersjs/transport-commons

## [4.4.1](https://github.com/feathersjs/feathers/compare/v4.4.0...v4.4.1) (2019-11-27)

### Bug Fixes

- Gracefully handle errors in publishers ([#1710](https://github.com/feathersjs/feathers/issues/1710)) ([0616306](https://github.com/feathersjs/feathers/commit/061630696762e9dbf1dc4e738094992ba16989fc))

# [4.4.0](https://github.com/feathersjs/feathers/compare/v4.3.11...v4.4.0) (2019-11-27)

### Bug Fixes

- **transport-commons:** Allow to properly chain SocketIo client.off ([#1706](https://github.com/feathersjs/feathers/issues/1706)) ([a4aecbc](https://github.com/feathersjs/feathers/commit/a4aecbcd3578c1cf4ecffb3a58fb6d26e15ee513))

## [4.3.11](https://github.com/feathersjs/feathers/compare/v4.3.10...v4.3.11) (2019-11-11)

**Note:** Version bump only for package @feathersjs/transport-commons

## [4.3.10](https://github.com/feathersjs/feathers/compare/v4.3.9...v4.3.10) (2019-10-26)

**Note:** Version bump only for package @feathersjs/transport-commons

## [4.3.9](https://github.com/feathersjs/feathers/compare/v4.3.8...v4.3.9) (2019-10-26)

**Note:** Version bump only for package @feathersjs/transport-commons

## [4.3.7](https://github.com/feathersjs/feathers/compare/v4.3.6...v4.3.7) (2019-10-14)

**Note:** Version bump only for package @feathersjs/transport-commons

## [4.3.4](https://github.com/feathersjs/feathers/compare/v4.3.3...v4.3.4) (2019-10-03)

**Note:** Version bump only for package @feathersjs/transport-commons

## [4.3.3](https://github.com/feathersjs/feathers/compare/v4.3.2...v4.3.3) (2019-09-21)

**Note:** Version bump only for package @feathersjs/transport-commons

## [4.3.2](https://github.com/feathersjs/feathers/compare/v4.3.1...v4.3.2) (2019-09-16)

**Note:** Version bump only for package @feathersjs/transport-commons

## [4.3.1](https://github.com/feathersjs/feathers/compare/v4.3.0...v4.3.1) (2019-09-09)

### Bug Fixes

- Fix regression in transport commons ([#1551](https://github.com/feathersjs/feathers/issues/1551)) ([ed9e934](https://github.com/feathersjs/feathers/commit/ed9e934))

# [4.3.0](https://github.com/feathersjs/feathers/compare/v4.3.0-pre.4...v4.3.0) (2019-08-27)

**Note:** Version bump only for package @feathersjs/transport-commons

# [4.3.0-pre.4](https://github.com/feathersjs/feathers/compare/v4.3.0-pre.3...v4.3.0-pre.4) (2019-08-22)

**Note:** Version bump only for package @feathersjs/transport-commons

# [4.3.0-pre.3](https://github.com/feathersjs/feathers/compare/v4.3.0-pre.2...v4.3.0-pre.3) (2019-08-19)

### Bug Fixes

- Expire and remove authenticated real-time connections ([#1512](https://github.com/feathersjs/feathers/issues/1512)) ([2707c33](https://github.com/feathersjs/feathers/commit/2707c33))
- Update all dependencies ([7d53a00](https://github.com/feathersjs/feathers/commit/7d53a00))
- Use WeakMap to connect socket to connection ([#1509](https://github.com/feathersjs/feathers/issues/1509)) ([64807e3](https://github.com/feathersjs/feathers/commit/64807e3))

# [4.3.0-pre.2](https://github.com/feathersjs/feathers/compare/v4.3.0-pre.1...v4.3.0-pre.2) (2019-08-02)

### Bug Fixes

- Add getEntityId to JWT strategy and fix legacy Socket authentication ([#1488](https://github.com/feathersjs/feathers/issues/1488)) ([9a3b324](https://github.com/feathersjs/feathers/commit/9a3b324))
- Improve Params typing ([#1474](https://github.com/feathersjs/feathers/issues/1474)) ([54a3aa7](https://github.com/feathersjs/feathers/commit/54a3aa7))

# [4.3.0-pre.1](https://github.com/feathersjs/feathers/compare/v4.0.0-pre.5...v4.3.0-pre.1) (2019-07-11)

**Note:** Version bump only for package @feathersjs/transport-commons

# [4.0.0-pre.5](https://github.com/feathersjs/feathers/compare/v4.0.0-pre.4...v4.0.0-pre.5) (2019-07-10)

**Note:** Version bump only for package @feathersjs/transport-commons

# [4.0.0-pre.4](https://github.com/feathersjs/feathers/compare/v4.0.0-pre.3...v4.0.0-pre.4) (2019-07-05)

### Bug Fixes

- Clean up hooks code ([#1407](https://github.com/feathersjs/feathers/issues/1407)) ([f25c88b](https://github.com/feathersjs/feathers/commit/f25c88b))
- Improve transport-commons types ([#1396](https://github.com/feathersjs/feathers/issues/1396)) ([f9d8536](https://github.com/feathersjs/feathers/commit/f9d8536))

# [4.0.0-pre.3](https://github.com/feathersjs/feathers/compare/v4.0.0-pre.2...v4.0.0-pre.3) (2019-06-01)

### Bug Fixes

- Make oAuth paths more consistent and improve authentication client ([#1377](https://github.com/feathersjs/feathers/issues/1377)) ([adb2543](https://github.com/feathersjs/feathers/commit/adb2543))
- Update dependencies and fix tests ([#1373](https://github.com/feathersjs/feathers/issues/1373)) ([d743a7f](https://github.com/feathersjs/feathers/commit/d743a7f))

# [4.0.0-pre.2](https://github.com/feathersjs/feathers/compare/v4.0.0-pre.1...v4.0.0-pre.2) (2019-05-15)

### Bug Fixes

- Add fallback for legacy socket authenticate event ([#1356](https://github.com/feathersjs/feathers/issues/1356)) ([61b1056](https://github.com/feathersjs/feathers/commit/61b1056))
- Throw NotAuthenticated on token verification errors ([#1357](https://github.com/feathersjs/feathers/issues/1357)) ([e0120df](https://github.com/feathersjs/feathers/commit/e0120df))

### Features

- Add global disconnect event ([#1355](https://github.com/feathersjs/feathers/issues/1355)) ([85afcca](https://github.com/feathersjs/feathers/commit/85afcca))

# [4.0.0-pre.1](https://github.com/feathersjs/feathers/compare/v4.0.0-pre.0...v4.0.0-pre.1) (2019-05-08)

### Bug Fixes

- Add registerPublisher alias for .publish ([#1302](https://github.com/feathersjs/feathers/issues/1302)) ([98fe8f8](https://github.com/feathersjs/feathers/commit/98fe8f8))

# [4.0.0-pre.0](https://github.com/feathersjs/feathers/compare/v3.2.0-pre.1...v4.0.0-pre.0) (2019-04-21)

### Bug Fixes

- Compare socket event data using lodash's isEqual instead of indexOf ([#1061](https://github.com/feathersjs/feathers/issues/1061)) ([f706db3](https://github.com/feathersjs/feathers/commit/f706db3))
- Make Mocha a proper devDependency for every repository ([#1053](https://github.com/feathersjs/feathers/issues/1053)) ([9974803](https://github.com/feathersjs/feathers/commit/9974803))
- Update adapter common tests ([#1135](https://github.com/feathersjs/feathers/issues/1135)) ([8166dda](https://github.com/feathersjs/feathers/commit/8166dda))
- Update all dependencies to latest ([#1206](https://github.com/feathersjs/feathers/issues/1206)) ([e51e0f6](https://github.com/feathersjs/feathers/commit/e51e0f6))
- **package:** update debug to version 3.0.0 ([#45](https://github.com/feathersjs/feathers/issues/45)) ([9b9bde5](https://github.com/feathersjs/feathers/commit/9b9bde5))

### Features

- Add TypeScript definitions ([#1275](https://github.com/feathersjs/feathers/issues/1275)) ([9dd6713](https://github.com/feathersjs/feathers/commit/9dd6713))
- Allow registering a service at the root level ([#1115](https://github.com/feathersjs/feathers/issues/1115)) ([c73d322](https://github.com/feathersjs/feathers/commit/c73d322))

## [4.2.1](https://github.com/feathersjs/feathers/compare/@feathersjs/transport-commons@4.2.0...@feathersjs/transport-commons@4.2.1) (2019-01-02)

### Bug Fixes

- Update adapter common tests ([#1135](https://github.com/feathersjs/feathers/issues/1135)) ([8166dda](https://github.com/feathersjs/feathers/commit/8166dda))

<a name="4.2.0"></a>

# [4.2.0](https://github.com/feathersjs/feathers/compare/@feathersjs/transport-commons@4.1.6...@feathersjs/transport-commons@4.2.0) (2018-12-16)

### Features

- Allow registering a service at the root level ([#1115](https://github.com/feathersjs/feathers/issues/1115)) ([c73d322](https://github.com/feathersjs/feathers/commit/c73d322))

<a name="4.1.6"></a>

## [4.1.6](https://github.com/feathersjs/feathers/compare/@feathersjs/transport-commons@4.1.5...@feathersjs/transport-commons@4.1.6) (2018-10-25)

### Bug Fixes

- Compare socket event data using lodash's isEqual instead of indexOf ([#1061](https://github.com/feathersjs/feathers/issues/1061)) ([f706db3](https://github.com/feathersjs/feathers/commit/f706db3))
- Make Mocha a proper devDependency for every repository ([#1053](https://github.com/feathersjs/feathers/issues/1053)) ([9974803](https://github.com/feathersjs/feathers/commit/9974803))

<a name="4.1.5"></a>

## [4.1.5](https://github.com/feathersjs/feathers/compare/@feathersjs/transport-commons@4.1.4...@feathersjs/transport-commons@4.1.5) (2018-09-21)

**Note:** Version bump only for package @feathersjs/transport-commons

<a name="4.1.4"></a>

## [4.1.4](https://github.com/feathersjs/feathers/compare/@feathersjs/transport-commons@4.1.3...@feathersjs/transport-commons@4.1.4) (2018-09-17)

**Note:** Version bump only for package @feathersjs/transport-commons

<a name="4.1.3"></a>

## [4.1.3](https://github.com/feathersjs/feathers/compare/@feathersjs/transport-commons@4.1.2...@feathersjs/transport-commons@4.1.3) (2018-09-02)

**Note:** Version bump only for package @feathersjs/transport-commons

<a name="4.1.2"></a>

## 4.1.2

- Migrate to Monorepo ([feathers#462](https://github.com/feathersjs/feathers/issues/462))

## [v4.1.1](https://github.com/feathersjs/transport-commons/tree/v4.1.1) (2018-07-03)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v4.1.0...v4.1.1)

**Merged pull requests:**

- Properly dispatch arrays that do not come from Feathers hook events [\#77](https://github.com/feathersjs/transport-commons/pull/77) ([daffl](https://github.com/daffl))

## [v4.1.0](https://github.com/feathersjs/transport-commons/tree/v4.1.0) (2018-06-28)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v4.0.2...v4.1.0)

**Merged pull requests:**

- Remove empty channels [\#75](https://github.com/feathersjs/transport-commons/pull/75) ([daffl](https://github.com/daffl))

## [v4.0.2](https://github.com/feathersjs/transport-commons/tree/v4.0.2) (2018-06-12)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v4.0.1...v4.0.2)

**Merged pull requests:**

- Fix looking up invalid path names through sockets [\#76](https://github.com/feathersjs/transport-commons/pull/76) ([daffl](https://github.com/daffl))

## [v4.0.1](https://github.com/feathersjs/transport-commons/tree/v4.0.1) (2018-05-30)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v4.0.0...v4.0.1)

**Merged pull requests:**

- Update Codeclimate settings [\#74](https://github.com/feathersjs/transport-commons/pull/74) ([daffl](https://github.com/daffl))

## [v4.0.0](https://github.com/feathersjs/transport-commons/tree/v4.0.0) (2018-02-09)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v3.2.0...v4.0.0)

**Closed issues:**

- Additional data for client errors [\#72](https://github.com/feathersjs/transport-commons/issues/72)

**Merged pull requests:**

- Throw a Timeout error on send timeout instead of Error [\#73](https://github.com/feathersjs/transport-commons/pull/73) ([TimNZ](https://github.com/TimNZ))
- Pass connection in params [\#71](https://github.com/feathersjs/transport-commons/pull/71) ([daffl](https://github.com/daffl))
- Move socket handling into its own file [\#70](https://github.com/feathersjs/transport-commons/pull/70) ([daffl](https://github.com/daffl))

## [v3.2.0](https://github.com/feathersjs/transport-commons/tree/v3.2.0) (2018-01-30)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v3.1.5...v3.2.0)

**Closed issues:**

- Publishing to a channel fails after passing safety check [\#66](https://github.com/feathersjs/transport-commons/issues/66)
- Feathers Server Ends unexpected if some arg to socket.io is a ipv6 local subnet [\#65](https://github.com/feathersjs/transport-commons/issues/65)

**Merged pull requests:**

- Rename to @feathersjs/transport-commons [\#69](https://github.com/feathersjs/transport-commons/pull/69) ([daffl](https://github.com/daffl))
- Switch to Radix tree based routing [\#68](https://github.com/feathersjs/transport-commons/pull/68) ([daffl](https://github.com/daffl))
- Update mocha to the latest version 🚀 [\#64](https://github.com/feathersjs/transport-commons/pull/64) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Update semistandard to the latest version 🚀 [\#63](https://github.com/feathersjs/transport-commons/pull/63) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))

## [v3.1.5](https://github.com/feathersjs/transport-commons/tree/v3.1.5) (2017-12-12)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v3.1.4...v3.1.5)

## [v3.1.4](https://github.com/feathersjs/transport-commons/tree/v3.1.4) (2017-12-12)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v3.1.3...v3.1.4)

**Merged pull requests:**

- Fix dispatching of arrays [\#62](https://github.com/feathersjs/transport-commons/pull/62) ([daffl](https://github.com/daffl))

## [v3.1.3](https://github.com/feathersjs/transport-commons/tree/v3.1.3) (2017-12-12)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v3.1.2...v3.1.3)

**Merged pull requests:**

- Make sure that each entry in an array is dispatched as its own even [\#61](https://github.com/feathersjs/transport-commons/pull/61) ([daffl](https://github.com/daffl))

## [v3.1.2](https://github.com/feathersjs/transport-commons/tree/v3.1.2) (2017-12-06)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v3.1.1...v3.1.2)

**Merged pull requests:**

- Fix another error when there are no results [\#60](https://github.com/feathersjs/transport-commons/pull/60) ([daffl](https://github.com/daffl))

## [v3.1.1](https://github.com/feathersjs/transport-commons/tree/v3.1.1) (2017-12-06)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v3.1.0...v3.1.1)

**Merged pull requests:**

- Always use a combined channel [\#59](https://github.com/feathersjs/transport-commons/pull/59) ([daffl](https://github.com/daffl))

## [v3.1.0](https://github.com/feathersjs/transport-commons/tree/v3.1.0) (2017-12-06)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v3.0.1...v3.1.0)

**Merged pull requests:**

- Give channel dispatchers a precedence [\#58](https://github.com/feathersjs/transport-commons/pull/58) ([daffl](https://github.com/daffl))

## [v3.0.1](https://github.com/feathersjs/transport-commons/tree/v3.0.1) (2017-11-03)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v3.0.0...v3.0.1)

**Closed issues:**

- Allow socket calls without params and callback [\#54](https://github.com/feathersjs/transport-commons/issues/54)

**Merged pull requests:**

- Allow socket calls without query and callback [\#55](https://github.com/feathersjs/transport-commons/pull/55) ([daffl](https://github.com/daffl))

## [v3.0.0](https://github.com/feathersjs/transport-commons/tree/v3.0.0) (2017-11-01)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v3.0.0-pre.7...v3.0.0)

## [v3.0.0-pre.7](https://github.com/feathersjs/transport-commons/tree/v3.0.0-pre.7) (2017-10-25)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v3.0.0-pre.6...v3.0.0-pre.7)

**Merged pull requests:**

- Update to better returnHook handling [\#53](https://github.com/feathersjs/transport-commons/pull/53) ([daffl](https://github.com/daffl))

## [v3.0.0-pre.6](https://github.com/feathersjs/transport-commons/tree/v3.0.0-pre.6) (2017-10-21)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v3.0.0-pre.5...v3.0.0-pre.6)

**Closed issues:**

- feathers-socket-commons produces error when it get bundled and steal-socket.io gets used as connection [\#44](https://github.com/feathersjs/transport-commons/issues/44)
- Surface src/events.js lines 44-69 for feathers-hooks-common/src/filters/combine.js [\#40](https://github.com/feathersjs/transport-commons/issues/40)

**Merged pull requests:**

- Updates for Feathers v3 \(Buzzard\) [\#52](https://github.com/feathersjs/transport-commons/pull/52) ([daffl](https://github.com/daffl))
- Rename repository and use npm scope [\#51](https://github.com/feathersjs/transport-commons/pull/51) ([daffl](https://github.com/daffl))

## [v3.0.0-pre.5](https://github.com/feathersjs/transport-commons/tree/v3.0.0-pre.5) (2017-10-18)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v3.0.0-pre.4...v3.0.0-pre.5)

**Merged pull requests:**

- Pass events property to the client [\#50](https://github.com/feathersjs/transport-commons/pull/50) ([daffl](https://github.com/daffl))

## [v3.0.0-pre.4](https://github.com/feathersjs/transport-commons/tree/v3.0.0-pre.4) (2017-10-17)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v3.0.0-pre.3...v3.0.0-pre.4)

**Merged pull requests:**

- Fix the event name and add some channel debug statements [\#49](https://github.com/feathersjs/transport-commons/pull/49) ([daffl](https://github.com/daffl))

## [v3.0.0-pre.3](https://github.com/feathersjs/transport-commons/tree/v3.0.0-pre.3) (2017-10-16)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v3.0.0-pre.2...v3.0.0-pre.3)

**Merged pull requests:**

- Update mocha to the latest version 🚀 [\#48](https://github.com/feathersjs/transport-commons/pull/48) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))

## [v3.0.0-pre.2](https://github.com/feathersjs/transport-commons/tree/v3.0.0-pre.2) (2017-09-28)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v3.0.0-pre.1...v3.0.0-pre.2)

**Merged pull requests:**

- Add feathers-channels [\#47](https://github.com/feathersjs/transport-commons/pull/47) ([daffl](https://github.com/daffl))

## [v3.0.0-pre.1](https://github.com/feathersjs/transport-commons/tree/v3.0.0-pre.1) (2017-09-08)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v2.4.0...v3.0.0-pre.1)

**Fixed bugs:**

- Socket events don't fire for sub-apps nested more than 2 deep [\#5](https://github.com/feathersjs/transport-commons/issues/5)

**Closed issues:**

- more tests [\#38](https://github.com/feathersjs/transport-commons/issues/38)

**Merged pull requests:**

- Prepare v3.0-pre [\#46](https://github.com/feathersjs/transport-commons/pull/46) ([daffl](https://github.com/daffl))
- Update debug to the latest version 🚀 [\#45](https://github.com/feathersjs/transport-commons/pull/45) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Update feathers-socketio to the latest version 🚀 [\#43](https://github.com/feathersjs/transport-commons/pull/43) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Update semistandard to the latest version 🚀 [\#42](https://github.com/feathersjs/transport-commons/pull/42) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))
- Update dependencies to enable Greenkeeper 🌴 [\#41](https://github.com/feathersjs/transport-commons/pull/41) ([greenkeeper[bot]](https://github.com/apps/greenkeeper))

## [v2.4.0](https://github.com/feathersjs/transport-commons/tree/v2.4.0) (2017-01-07)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v2.3.1...v2.4.0)

**Implemented enhancements:**

- support service.json [\#34](https://github.com/feathersjs/transport-commons/issues/34)
- Socket event filters should not force returning data [\#4](https://github.com/feathersjs/transport-commons/issues/4)
- bootstrap service.filters [\#37](https://github.com/feathersjs/transport-commons/pull/37) ([slajax](https://github.com/slajax))

**Closed issues:**

- Sockets timed out request - retry on reconnection \[feat?\] [\#32](https://github.com/feathersjs/transport-commons/issues/32)

**Merged pull requests:**

- Normalize arguments when client sends packed data. [\#39](https://github.com/feathersjs/transport-commons/pull/39) ([devel-pa](https://github.com/devel-pa))
- Create .codeclimate.yml [\#33](https://github.com/feathersjs/transport-commons/pull/33) ([larkinscott](https://github.com/larkinscott))
- Update feathers-commons to version 0.8.0 🚀 [\#31](https://github.com/feathersjs/transport-commons/pull/31) ([greenkeeperio-bot](https://github.com/greenkeeperio-bot))
- jshint —\> semistandard [\#30](https://github.com/feathersjs/transport-commons/pull/30) ([corymsmith](https://github.com/corymsmith))
- Code coverage [\#29](https://github.com/feathersjs/transport-commons/pull/29) ([ekryski](https://github.com/ekryski))

## [v2.3.1](https://github.com/feathersjs/transport-commons/tree/v2.3.1) (2016-09-02)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v2.3.0...v2.3.1)

**Merged pull requests:**

- Make service off method be namespaced [\#26](https://github.com/feathersjs/transport-commons/pull/26) ([t2t2](https://github.com/t2t2))
- Update mocha to version 3.0.0 🚀 [\#25](https://github.com/feathersjs/transport-commons/pull/25) ([greenkeeperio-bot](https://github.com/greenkeeperio-bot))

## [v2.3.0](https://github.com/feathersjs/transport-commons/tree/v2.3.0) (2016-07-24)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v2.2.1...v2.3.0)

**Fixed bugs:**

- Error in filter chain for 'created' event after app.authenticate\(\) [\#12](https://github.com/feathersjs/transport-commons/issues/12)

**Merged pull requests:**

- Skip subsequent filters instead of rejecting the promise [\#24](https://github.com/feathersjs/transport-commons/pull/24) ([daffl](https://github.com/daffl))

## [v2.2.1](https://github.com/feathersjs/transport-commons/tree/v2.2.1) (2016-07-05)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v2.2.0...v2.2.1)

## [v2.2.0](https://github.com/feathersjs/transport-commons/tree/v2.2.0) (2016-07-05)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v2.1.0...v2.2.0)

**Implemented enhancements:**

- Support native websockets directly [\#8](https://github.com/feathersjs/transport-commons/issues/8)

**Fixed bugs:**

- Calling `off` on primus fails [\#7](https://github.com/feathersjs/transport-commons/issues/7)

**Closed issues:**

- Should add other eventEmitter methods [\#22](https://github.com/feathersjs/transport-commons/issues/22)
- Patch event sends the whole data back [\#21](https://github.com/feathersjs/transport-commons/issues/21)

**Merged pull requests:**

- Pass all EventEmitter methods to the client connection [\#23](https://github.com/feathersjs/transport-commons/pull/23) ([daffl](https://github.com/daffl))

## [v2.1.0](https://github.com/feathersjs/transport-commons/tree/v2.1.0) (2016-05-29)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v2.0.0...v2.1.0)

**Closed issues:**

- Client should convert error objects to feathers-errors [\#19](https://github.com/feathersjs/transport-commons/issues/19)

**Merged pull requests:**

- Make client convert to feathers-errors [\#20](https://github.com/feathersjs/transport-commons/pull/20) ([daffl](https://github.com/daffl))

## [v2.0.0](https://github.com/feathersjs/transport-commons/tree/v2.0.0) (2016-05-23)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v1.0.0...v2.0.0)

**Merged pull requests:**

- Better handling of sub-apps and sockets [\#18](https://github.com/feathersjs/transport-commons/pull/18) ([daffl](https://github.com/daffl))
- Update babel-plugin-add-module-exports to version 0.2.0 🚀 [\#17](https://github.com/feathersjs/transport-commons/pull/17) ([greenkeeperio-bot](https://github.com/greenkeeperio-bot))
- babel-polyfill@6.7.4 breaks build 🚨 [\#16](https://github.com/feathersjs/transport-commons/pull/16) ([greenkeeperio-bot](https://github.com/greenkeeperio-bot))

## [v1.0.0](https://github.com/feathersjs/transport-commons/tree/v1.0.0) (2016-04-28)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v0.2.3...v1.0.0)

**Implemented enhancements:**

- Support acknowledgement timeouts [\#9](https://github.com/feathersjs/transport-commons/issues/9)

**Closed issues:**

- Feathers over sockets is totally silent when a hook has errors [\#13](https://github.com/feathersjs/transport-commons/issues/13)
- Listener warning when you register your own events on the socket [\#10](https://github.com/feathersjs/transport-commons/issues/10)

**Merged pull requests:**

- Support timeouts for socket clients [\#15](https://github.com/feathersjs/transport-commons/pull/15) ([daffl](https://github.com/daffl))
- Convert errors in socket callbacks [\#14](https://github.com/feathersjs/transport-commons/pull/14) ([daffl](https://github.com/daffl))

## [v0.2.3](https://github.com/feathersjs/transport-commons/tree/v0.2.3) (2016-04-16)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v0.2.2...v0.2.3)

**Merged pull requests:**

- Remove connection setMaxListeners [\#11](https://github.com/feathersjs/transport-commons/pull/11) ([daffl](https://github.com/daffl))

## [v0.2.2](https://github.com/feathersjs/transport-commons/tree/v0.2.2) (2016-03-22)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v0.2.1...v0.2.2)

**Merged pull requests:**

- Allow chaining event listeners. [\#6](https://github.com/feathersjs/transport-commons/pull/6) ([joshuajabbour](https://github.com/joshuajabbour))

## [v0.2.1](https://github.com/feathersjs/transport-commons/tree/v0.2.1) (2016-03-08)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v0.2.0...v0.2.1)

**Merged pull requests:**

- Set connection max listeners and better debug messages [\#3](https://github.com/feathersjs/transport-commons/pull/3) ([daffl](https://github.com/daffl))

## [v0.2.0](https://github.com/feathersjs/transport-commons/tree/v0.2.0) (2016-02-08)

[Full Changelog](https://github.com/feathersjs/transport-commons/compare/v0.1.0...v0.2.0)

**Merged pull requests:**

- Query params [\#2](https://github.com/feathersjs/transport-commons/pull/2) ([ekryski](https://github.com/ekryski))
- Adding nsp check [\#1](https://github.com/feathersjs/transport-commons/pull/1) ([marshallswain](https://github.com/marshallswain))

## [v0.1.0](https://github.com/feathersjs/transport-commons/tree/v0.1.0) (2016-01-21)

\* _This Change Log was automatically generated by [github_changelog_generator](https://github.com/skywinder/Github-Changelog-Generator)_
