import { Id, NullableId, Params, ServiceInterface } from '@feathersjs/feathers';
interface ServiceOptions {
    name: string;
    connection: any;
    method: string;
    events?: string[];
}
export type SocketService<T = any, D = Partial<any>, P extends Params = Params> = Service<T, D, P>;
export declare class Service<T = any, D = Partial<T>, P extends Params = Params> implements ServiceInterface<T, D, P> {
    events: string[];
    path: string;
    connection: any;
    method: string;
    constructor(options: ServiceOptions);
    send<X = any>(method: string, ...args: any[]): Promise<X>;
    methods(this: any, ...names: string[]): any;
    _find(params?: Params): Promise<T | T[]>;
    find(params?: Params): Promise<T | T[]>;
    _get(id: Id, params?: Params): Promise<T>;
    get(id: Id, params?: Params): Promise<T>;
    _create(data: D, params?: Params): Promise<T>;
    create(data: D, params?: Params): Promise<T>;
    _update(id: NullableId, data: D, params?: Params): Promise<T>;
    update(id: NullableId, data: D, params?: Params): Promise<T>;
    _patch(id: NullableId, data: D, params?: Params): Promise<T | T[]>;
    patch(id: NullableId, data: D, params?: Params): Promise<T | T[]>;
    _remove(id: NullableId, params?: Params): Promise<T | T[]>;
    remove(id: NullableId, params?: Params): Promise<T | T[]>;
    off(name: string, ...args: any[]): any;
}
export {};
