"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.noopDebug = noopDebug;
exports.setDebug = setDebug;
exports.createDebug = createDebug;
const debuggers = {};
function noopDebug() {
    return function () { };
}
let defaultInitializer = noopDebug;
function setDebug(debug) {
    defaultInitializer = debug;
    Object.keys(debuggers).forEach((name) => {
        debuggers[name] = debug(name);
    });
}
function createDebug(name) {
    if (!debuggers[name]) {
        debuggers[name] = defaultInitializer(name);
    }
    return (...args) => debuggers[name](...args);
}
//# sourceMappingURL=debug.js.map