'use strict';

var qs = require('qs');

var _config = require('./config');
var oauth1 = require('./flow/oauth1');
var oauth2 = require('./flow/oauth2');

module.exports = function (_ref) {
  var config = _ref.config;

  var config = _config(config);

  var connect = function connect(_ref2) {
    var session = _ref2.session,
        _ref2$state = _ref2.state,
        state = _ref2$state === undefined ? {} : _ref2$state;
    return new Promise(function (resolve) {
      var provider = _config.provider(config, session, state);
      var response = transport(provider, session, state);

      if (provider.oauth === 1) {
        oauth1.request(provider).then(function (result) {
          session.request = result.body;
          oauth1.authorize(provider, result.body).then(function (url) {
            return resolve({ url });
          });
        }).catch(function (err) {
          return resolve(response(err));
        });
      } else if (provider.oauth === 2) {
        session.state = provider.state;
        session.nonce = provider.nonce;
        session.code_verifier = provider.code_verifier;
        oauth2.authorize(provider).then(function (url) {
          return resolve({ url });
        }).catch(function (err) {
          return resolve(response(err));
        });
      } else {
        resolve(response({ error: 'Grant: missing or misconfigured provider' }));
      }
    });
  };

  var callback = function callback(_ref3) {
    var session = _ref3.session,
        query = _ref3.query,
        _ref3$state = _ref3.state,
        state = _ref3$state === undefined ? {} : _ref3$state;
    return new Promise(function (resolve) {
      var provider = _config.provider(config, session, state);
      var response = transport(provider, session, state);

      if (provider.oauth === 1) {
        oauth1.access(provider, session.request, query).then(function (data) {
          return resolve(response(data));
        }).catch(function (err) {
          return resolve(response(err));
        });
      } else if (provider.oauth === 2) {
        oauth2.access(provider, query, session).then(function (data) {
          return resolve(response(data));
        }).catch(function (err) {
          return resolve(response(err));
        });
      } else {
        resolve(response({ error: 'Grant: missing session or misconfigured provider' }));
      }
    });
  };

  return { config, connect, callback };
};

var transport = function transport(provider, session, state) {
  return function (data) {
    if (!provider.transport || provider.transport === 'querystring') {
      return provider.callback ? { url: `${provider.callback}?${qs.stringify(data)}` } : { error: qs.stringify(data) };
    } else if (provider.transport === 'session') {
      session.response = data;
      return provider.callback ? { url: provider.callback } : {};
    } else if (provider.transport === 'state') {
      state.response = data;
      return {};
    } else {
      return { error: qs.stringify(data) };
    }
  };
};