
var http = require('http')
var qs = require('qs')
var cookie = require('cookie')
var signature = require('cookie-signature')
var _consumer = require('../consumer')

var _store = (cache = {}) => ({
  get: async ({id}) => cache[id],
  set: async ({id, state}) => cache[id] = state,
})

var store = _store()
var secret = 'grant'

// /:path*/connect/:provider/:override? + querystring
var regex = /^(?:\/([^\\/]+?(?:\/[^\\/]+?)*))?\/connect\/([^\\/]+?)(?:\/([^\\/]+?))?\/?(?:\?([^/]+))?$/i


module.exports = function (config) {
  var app = http.createServer()
  var consumer = _consumer({config})
  app.config = consumer.config

  app.on('request', async (req, res) => {
    var match = regex.exec(req.url)
    if (!match) {
      return
    }

    var provider = match[2]
    var override = match[3]
    var query = qs.parse(match[4])

    // callback
    if (req.method === 'GET' && override === 'callback') {
      var {grant} = cookie.parse(req.headers.cookie)
      var id = signature.unsign(grant, secret)
      var state = await store.get({id})

      var {error, url} = await consumer.callback({state, query}) // mutates state
      await store.set({id, state})
      // when callback is missing
      if (error) {
        res.statusCode = 400
        res.end(error)
      }
      else {
        res.statusCode = 302
        res.setHeader('location', url)
        res.end()
      }
    }

    // connect
    else {
      var state = {}
      state.provider = provider

      if (override) {
        state.override = override
      }
      if (req.method === 'GET' && Object.keys(query).length) {
        state.dynamic = query
      }
      else if (req.method === 'POST') {
        var body = qs.parse(await buffer(res))
        if (Object.keys(body).length) {
          state.dynamic = body
        }
      }

      // session
      var id = uuid()
      // cookie
      var {sid, data} = sign({id, secret})
      var header = [].concat(res.getHeader('set-cookie'), data).filter(Boolean)
      res.setHeader('set-cookie', header)

      var {error, url} = await consumer.connect({state}) // mutates state
      await store.set({id, state})
      // when callback is missing
      if (error) {
        res.statusCode = 400
        res.end(error)
      }
      else {
        res.statusCode = 302
        res.setHeader('location', url)
        res.end()
      }
    }
  })

  return app
}

var uuid = () => {
  return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, (c) => {
    var r = Math.random() * 16|0
    var v = c == 'x' ? r : (r&0x3|0x8)
    return v.toString(16)
  })
}

var sign = ({id, secret}) => {
  var name = 'grant'
  var options = {path: '/', httpOnly: true, secure: false, maxAge: null}
  var sid = signature.sign(id, secret)
  var data = cookie.serialize(name, sid, options)
  return {sid, data}
}

var buffer = (res) => new Promise((resolve, reject) => {
  var body = []
  res
    .on('data', (chunk) => body.push(chunk))
    .on('end', () => resolve(Buffer.concat(body).toString('utf8')))
    .on('error', reject)
})
