'use strict';

var ctor = function ctor() {
  return function () {
    for (var _len = arguments.length, fns = Array(_len), _key = 0; _key < _len; _key++) {
      fns[_key] = arguments[_key];
    }

    return function (args) {
      return fns.reduce(function (p, f) {
        return p.then(f);
      }, Promise.resolve(args));
    };
  };
};

var compose = ctor();

var load = function load(type, middlewares) {
  return middlewares.reduce(function (all, mw) {
    return all[mw] = require(`./${type}/${mw}`), all;
  }, {});
};

var Request = load('request', ['defaults', 'url', 'proxy', 'qs', 'form', 'json', 'body', 'auth', 'length', 'send']);

var Response = load('response', ['buffer', 'gzip', 'string', 'parse', 'status', 'redirect']);

var utils = load('utils', ['error', 'log']);

var request = function request(Request) {
  return function (args) {
    return compose(Request.defaults(args), function () {
      return args.url ? Request.url(args.url) : function (_ref) {
        var options = _ref.options;
        return { options };
      };
    }(), function () {
      return args.proxy ? Request.proxy(args.proxy) : function (_ref2) {
        var options = _ref2.options;
        return { options };
      };
    }(), function () {
      return args.qs ? Request.qs(args.qs, args.redirect) : function (_ref3) {
        var options = _ref3.options;
        return { options };
      };
    }(), function () {
      return args.cookie ? Request.cookie(args.cookie) : function (_ref4) {
        var options = _ref4.options;
        return { options };
      };
    }(), function () {
      return args.form ? Request.form(args.form) : args.json ? Request.json(args.json) : args.multipart ? Request.multipart(args.multipart) : args.body ? Request.body(args.body) : function (_ref5) {
        var options = _ref5.options;
        return { options };
      };
    }(), function () {
      return args.auth ? Request.auth(args.auth) : args.oauth ? Request.oauth(args.oauth) : function (_ref6) {
        var options = _ref6.options,
            body = _ref6.body;
        return { options, body };
      };
    }(), function () {
      return function (_ref7) {
        var options = _ref7.options,
            body = _ref7.body;
        return body ? Request.length()({ options, body }) : { options };
      };
    }(), Request.send())();
  };
};

var client = function client(Request, Response) {
  return function (args) {
    return compose(function (_) {
      return request(Request)(args);
    }, function () {
      return args.cookie ? Response.cookie(args.cookie) : function (_ref8) {
        var options = _ref8.options,
            res = _ref8.res;
        return { options, res };
      };
    }(), Response.buffer(), Response.gzip(), Response.string(args.encoding), Response.parse(), Response.status(), Response.redirect(args, client(Request, Response)))();
  };
};

var buffer = function buffer(Request, Response) {
  return function (args) {
    return compose(function (_) {
      return request(Request)(args);
    }, function () {
      return args.cookie ? Response.cookie(args.cookie) : function (_ref9) {
        var options = _ref9.options,
            res = _ref9.res;
        return { options, res };
      };
    }(), Response.buffer(), Response.gzip(), Response.status(), Response.redirect(args, buffer(Request, Response)))();
  };
};

var stream = function stream(Request, Response) {
  return function (args) {
    return compose(function (_) {
      return request(Request)(args);
    }, function () {
      return args.cookie ? Response.cookie(args.cookie) : function (_ref10) {
        var options = _ref10.options,
            res = _ref10.res;
        return { options, res };
      };
    }(), Response.status()
    // TODO: should buffer the read chunks and re-write them
    // Response.redirect(args, stream),

    )();
  };
};

var extend = function extend(mw) {
  return function () {
    var req = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : Object.assign({}, Request, mw.Request);
    var res = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Object.assign({}, Response, mw.Response);
    return Object.assign(ctor(), {
      Request: req,
      Response: res,
      client: client(req, res),
      buffer: buffer(req, res),
      stream: stream(req, res),
      extend
    });
  }();
};

module.exports = extend({ Request, Response });