'use strict';

var querystring = require('querystring');

module.exports = function (form) {
  return function (_ref) {
    var options = _ref.options,
        headers = _ref.options.headers;


    var header = Object.keys(headers).find(function (name) {
      return name.toLowerCase() === 'content-type';
    });

    if (!header) {
      headers['content-type'] = 'application/x-www-form-urlencoded';
    }

    var body = typeof form === 'string' ? form : typeof form === 'object' ? rfc3986(querystring.stringify(JSON.parse(JSON.stringify(form)))) : '';

    return { options, body };
  };
};

var rfc3986 = function rfc3986(str) {
  return str.replace(/[!'()*]/g, function (c) {
    return '%' + c.charCodeAt(0).toString(16).toUpperCase();
  });
};