'use strict';

module.exports = function (json) {
  return function (_ref) {
    var options = _ref.options,
        headers = _ref.options.headers;


    json = typeof json === 'object' ? JSON.stringify(json) : json || '';

    var header = Object.keys(headers).find(function (name) {
      return name.toLowerCase() === 'content-type';
    });

    if (!header) {
      headers['content-type'] = 'application/json';
    }

    return { options, body: json };
  };
};