'use strict';

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var querystring = require('querystring');

module.exports = function (qs) {
  var redirect = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  return function (_ref) {
    var options = _ref.options;

    if (redirect.followed) {
      return { options };
    }

    if (typeof qs === 'object') {
      qs = JSON.parse(JSON.stringify(qs));

      var _options$path$split = options.path.split('?'),
          _options$path$split2 = _slicedToArray(_options$path$split, 2),
          path = _options$path$split2[0],
          query = _options$path$split2[1];

      query = querystring.parse(query);

      qs = rfc3986(querystring.stringify(Object.assign(query, qs)));
      options.path = path + (qs ? `?${qs}` : '');
    } else if (typeof qs === 'string') {
      var _options$path$split3 = options.path.split('?'),
          _options$path$split4 = _slicedToArray(_options$path$split3, 2),
          path = _options$path$split4[0],
          query = _options$path$split4[1];

      options.path = path + (query ? `?${query}&${qs}` : `?${qs}`);
    }

    return { options };
  };
};

var rfc3986 = function rfc3986(str) {
  return str.replace(/[!'()*]/g, function (c) {
    return '%' + c.charCodeAt(0).toString(16).toUpperCase();
  });
};