'use strict';

var http = require('http');
var https = require('https');
var stream = require('stream');
var log = require('../utils/log');

module.exports = function () {
  return function (_ref) {
    var options = _ref.options,
        body = _ref.body;
    return new Promise(function (resolve, reject) {

      var req = (/https/.test(options.protocol) ? https : http).request(options).on('response', function (res) {
        log({ res });
        resolve({ options, res });
      }).on('error', reject).on('timeout', function () {
        var err = new Error('request-compose: timeout');
        err.code = 'ETIMEDOUT';
        req.emit('error', err);
        req.abort();
      }).setTimeout(options.timeout);body instanceof stream.Stream ? body.pipe(req) : req.end(body);

      log({ req, body, options });
    });
  };
};