'use strict';

var zlib = require('zlib');

module.exports = function () {
  return function (_ref) {
    var options = _ref.options,
        res = _ref.res,
        body = _ref.body,
        raw = _ref.raw;
    return new Promise(function (resolve, reject) {

      var header = Object.keys(res.headers).find(function (name) {
        return name.toLowerCase() === 'content-encoding';
      });

      var decode = /gzip/i.test(res.headers[header]) ? 'gunzip' : /deflate/i.test(res.headers[header]) ? 'inflate' : false;

      if (decode) {
        raw = body;

        var opts = {
          flush: zlib.Z_SYNC_FLUSH,
          finishFlush: zlib.Z_SYNC_FLUSH
        };

        zlib[decode](body, opts, function (err, decoded) {
          if (err) {
            reject(err);
            return;
          }
          resolve({ options, res, body: decoded, raw });
        });
      } else {
        resolve({ options, res, body, raw });
      }
    });
  };
};